/*
 * $Id: PublishPropertyWriter.java,v 1.3 2004/04/01 05:48:09 hn Exp $
 * Copyright Narushima Hironori. All rights reserved.
 */
package com.narucy.webpub.core.publish;

import java.io.*;

import org.w3c.dom.*;

import com.narucy.webpub.core.WebpubPlugin;

/**
 * 
 */
public class PublishPropertyWriter {

	private PublishPropertyWriter() {
	}
	
	public static void store(File file, Document doc){
		FileOutputStream out = null;
		try {
			out = new FileOutputStream(file);
			writeMappings(new PrintStream(out), doc);
		} catch (FileNotFoundException e) {
			WebpubPlugin.handleException(e);
		} finally{
			if( out != null) {
				try {
					out.close();
				} catch (IOException e1) {
					WebpubPlugin.handleException(e1);
				}
			}
		}
	}

	static void writeMappings(PrintStream out, Document doc){
		out.println("<?xml version=\"1.0\"?>");
		out.println("<mappings>");
		NodeList nodeList = doc.getDocumentElement().getElementsByTagName("mapping");
		for(int i=0; i<nodeList.getLength(); i++){
			out.println("\t<mapping>");
			
			Element mappingElem = (Element)nodeList.item(i);
			Element publishElem = (Element)mappingElem.getElementsByTagName("publish").item(0);
			out.print("\t\t<publish");
			
			NamedNodeMap map = publishElem.getAttributes();
			for(int j=0; j<map.getLength(); j++){
				Node n = map.item(j);
				out.print(" " + n.getNodeName() + "=\"" + n.getNodeValue() + "\"");
			}
			out.println(" />");
			out.println("\t</mapping>");
		}
		out.println("</mappings>");
	}


}

