/*
 * $Id: FileTocAdapterFactory.java,v 1.4 2004/04/25 00:42:31 hn Exp $
 * Copyright Narushima Hironori. All rights reserved.
 */
package com.narucy.webpub.core.toc;

import org.eclipse.core.resources.*;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.*;

import com.narucy.webpub.core.*;

/**
 * 
 */
public class FileTocAdapterFactory implements IAdapterFactory {

	public Object getAdapter(Object adaptableObject, Class adapterType) {
		if(adaptableObject instanceof IFile){
			try {
				return getTopic((IFile)adaptableObject);
			} catch (CoreException e) {
				WebpubPlugin.handleException(e);
			}
		}
		return null;
	}

	public Class[] getAdapterList() {
		return new Class[]{
			Topic.class,
			Toc.class,
		};
	}

	Topic getTopic(IFile file) throws CoreException {
		WebProject wp = (WebProject)file.getProject().getNature(WebProject.ID_NATURE);
		if(wp != null){
			IFile[] tocFiles = wp.getTocFiles();
			for (int i = 0; i < tocFiles.length; i++) {
				Toc toc = wp.getToc(tocFiles[i]);
				if(toc != null){
					Topic[] topics = toc.getAllTopics();
					for (int j = 0; j < topics.length; j++) {
						Topic t = (Topic)topics[j];
						if (file.equals(t.getAdapter(IResource.class))){
							return t;
						}
					}
				}
			}
		}
		return null;
	}

}
