/*
 * $Id: Toc.java,v 1.1 2004/03/24 18:00:15 hn Exp $
 * Copyright Narushima Hironori. All rights reserved.
 */
package com.narucy.webpub.core.toc;

import java.util.ArrayList;

import org.eclipse.core.resources.IFile;

/**
 * 
 */
public class Toc extends Topic {

	ArrayList
		listenerList = new ArrayList(),
		events = null;
	
	IFile tocFile;
	
	public Toc(String href, String label) {
		super(href, label, null);
	}
	
	public void addTocListener(TocListener l){
		listenerList.add(l);
	}

	public void removeTocListener(TocListener l){
		listenerList.remove(l);
	}
	
	protected TocListener[] getListeners(){
		return (TocListener[])listenerList.toArray(new TocListener[listenerList.size()]);
	}
	
	protected void stockEvent(TocEvent e){
		if(events == null){
			events = new ArrayList();
		}
		events.add(e);
	}
	
	public void fireChanged(){
		if(events == null){
			return;
		}
		TocEvent[] es = (TocEvent[])events.toArray(new TocEvent[events.size()]);
		events = null;
		TocListener[] listeners = getListeners();
		for (int i = 0; i < listeners.length; i++) {
			listeners[i].topicChanged(es);
		}
	}

	public void removeSubtopics(){
		Topic[] ts = getSubtopics();
		for (int i = 0; i < ts.length; i++) {
			removeTopic(ts[i]);
		}
	}
	
	public Topic[] getAllTopics() {
		ArrayList list = new ArrayList();
		searchTopics(getSubtopics(), list);
		return (Topic[])list.toArray(new Topic[list.size()]);
	}

	static void searchTopics(Topic[] topics, ArrayList list){
		for (int i = 0; i < topics.length; i++) {
			Topic topic = topics[i];
			list.add(topic);
			searchTopics(topic.getSubtopics(), list);
		}
	}

	public Topic findTopic(String href){
		Topic[] topics = getAllTopics();
		for (int i = 0; i < topics.length; i++) {
			Topic t = topics[i];
			if(t.getHref() != null && t.getHref().equals(href)){
				return (Topic)t;
			}
		}
		return null;
	}

	public Topic getTopic(String href) {
		Topic[] topics = getAllTopics();
		for (int i = 0; i < topics.length; i++) {
			Topic topic = topics[i];
			if(topic.getHref().equals(href)){
				return topic;
			}
		}
		return null;
	}
	
	public IFile getTocFile() {
		return tocFile;
	}

	public void setTocFile(IFile f) {
		tocFile = f;
	}
	
	public void applyToc(Toc toc){
		if(equals(toc)){
			return;
		}
		removeSubtopics();
		
		String[] keys = toc.getAttributeKeys();
		for (int i = 0; i < keys.length; i++) {
			String k = keys[i];
			setAttribute(k, toc.getAttribute(k));
		}
		
		Topic[] ts = toc.getSubtopics();
		for (int i = 0; i < ts.length; i++) {
			addTopic((Topic)ts[i].clone());
		}
	}
	
	public Object clone(){
		Toc toc = new Toc(getHref(), getLabel());
		toc.applyToc(this);
		return toc;
	}

	public boolean equals(Object obj) {
		if(super.equals(obj)){
			Toc toc = (Toc)obj;
			IFile f = toc.getTocFile();
			return f == tocFile || (f != null ? f.equals(tocFile) : tocFile.equals(f));
		}
		return false;
	}

}