/*
 * $Id: TocAdapterFactory.java,v 1.6 2004/04/25 00:42:31 hn Exp $
 * Copyright Narushima Hironori. All rights reserved.
 */
package com.narucy.webpub.core.toc;

import org.eclipse.core.resources.*;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.*;

import com.narucy.webpub.core.*;
import com.narucy.webpub.core.publish.SourceFileSeeker;

/**
 * 
 */
public class TocAdapterFactory implements IAdapterFactory {

	public Object getAdapter(Object adaptableObject, Class adapterType) {
		Topic topic = (Topic)adaptableObject;
			return topic instanceof Toc ?
				((Toc)topic).getTocFile() :
				findPublishFromAsTopic(topic);
	}

	public Class[] getAdapterList() {
		return new Class[]{ IResource.class };
	}

	IFile findPublishFromAsTopic(Topic topic){
		if(topic == null || topic.getHref() == null || topic.getHref().length() == 0){
			return null;
		}
		
		IFile tocFile = topic.getToc().getTocFile();
		if(tocFile != null){
			try {
				WebProject wp = (WebProject)tocFile.getProject().getNature(WebProject.ID_NATURE);
				if(wp != null){
					IFile publishedFile = wp.getFolder(WebProject.KEY_PUBLISH_FOLDER).getFile(new Path(topic.getHref()));
					return SourceFileSeeker.findSource(publishedFile);
				}
			} catch (CoreException e) {
				WebpubPlugin.handleException(e);
			}
		}
		
		return null;
	}
	

}
