/*
 * $Id: TocStore.java,v 1.7 2004/04/25 00:42:31 hn Exp $
 * Copyright Narushima Hironori. All rights reserved.
 */
package com.narucy.webpub.core.toc;

import java.io.*;

import org.eclipse.core.resources.*;
import org.eclipse.core.runtime.*;

import com.narucy.webpub.core.*;

/**
 * TocStore
 */
final public class TocStore {

	private TocStore(){
	}

	public static void storeToc(Toc toc, IFile out) throws CoreException {
		try {
			storeToc( toc, new FileOutputStream(out.getLocation().toFile()) );
		} catch (IOException e) {
			throw new CoreException(new Status(
				IStatus.ERROR,
				WebpubPlugin.ID_PLUGIN,
				IStatus.OK,
				e.getLocalizedMessage(),
				e));
		}
	}

	public static void storeToc(Toc toc, OutputStream out) throws IOException{
		OutputStreamWriter writer = null;
		try{
			String encoding = getEncoding(toc);
			writer = new OutputStreamWriter(out, encoding);
			writer.write(expandElement(toc, encoding));
		}catch(CoreException e){
			WebpubPlugin.handleException(e);
		}finally{
			if(writer != null){
				writer.close();
			}
		}
	}
	
	static String getEncoding(Toc toc) throws CoreException {
		String encoding = ResourcesPlugin.getPlugin().getPluginPreferences().getString(ResourcesPlugin.PREF_ENCODING);
		
		IResource tocFile = (IResource)toc.getAdapter(IResource.class);
		if(tocFile != null){
			WebProject wp = (WebProject)tocFile.getProject().getNature(WebProject.ID_NATURE);
			if(wp != null){
				encoding = wp.getString(WebProject.KEY_ENCODING);
			}
		}
		if(encoding.length() == 0){
			encoding = "UTF-8";
		}
		return encoding;
	}

	public static String expandElement(Toc toc) throws CoreException{
		return expandElement(toc, getEncoding(toc));
	}
	
	static String expandElement(Toc toc, String encoding){
		StringBuffer buff = new StringBuffer("<?xml version=\"1.0\" encoding=\"" + encoding +"\"?>\n\n");
		expandElement(buff, toc, 0);
		return buff.toString();
	}
	
	static void expandElement(StringBuffer buff, Topic topic, int level){
		for(int i=0; i<level; i++){
			buff.append('\t');
		}
		buff.append(topic instanceof Toc ? "<toc" : "<topic");
		String[] attrKeys = topic.getAttributeKeys();
		for (int i = 0; i < attrKeys.length; i++) {
			String k = attrKeys[i];
			buff.append(' ' + k + "=\"" + HTMLUtilities.escape(topic.getAttribute(k)) + "\"");
		}
		Topic[] subtopics = topic.getSubtopics();
		if(subtopics.length > 0){
			buff.append(">\n");
			for (int i = 0; i < subtopics.length; i++) {
				expandElement(buff, subtopics[i], level+1);
			}
			for(int i=0; i<level; i++){
				buff.append('\t');
			}
			buff.append(topic instanceof Toc ? "</toc>" : "</topic>\n");
		}else{
			buff.append(" />\n");
		}
	}
	
	


}
