/*
 * $Id: HTContentAssistProcessorTest.java,v 1.1 2004/04/11 08:39:55 hn Exp $
 * Copyright Narushima Hironori. All rights reserved.
 */
package com.narucy.webpub.ui.tests.editors.html;
import junit.framework.TestCase;

import org.eclipse.jface.text.*;

import com.narucy.webpub.ui.editors.ColorManager;
import com.narucy.webpub.ui.editors.html.HTContentAssistProcessor;

/**
 * 
 */
public class HTContentAssistProcessorTest extends TestCase {

	public HTContentAssistProcessorTest(String name) {
		super(name);
	}

	public void testGetCodeAssistPrefixString() throws BadLocationException {
		HTContentAssistProcessor processor = new HTContentAssistProcessor(new ColorManager());

		Document doc = new Document("<a><b></b></a>");
		assertEquals(null, processor.getElementComplationPrefix(doc, 0) );
		assertEquals("<", processor.getElementComplationPrefix(doc, 1) );
		assertEquals("<a", processor.getElementComplationPrefix(doc, 2) );
		assertEquals(null, processor.getElementComplationPrefix(doc, 3) );
		assertEquals("<b", processor.getElementComplationPrefix(doc, 5) );
	}

}
