/*
 * $Id: NewWebProjectWizardTest.java,v 1.4 2004/04/24 05:04:36 hn Exp $
 * Copyright Narushima Hironori. All rights reserved.
 */
package com.narucy.webpub.ui.tests.wizards;

import junit.framework.TestCase;

import org.eclipse.core.resources.*;
import org.eclipse.jface.wizard.*;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

import com.narucy.webpub.core.WebProject;
import com.narucy.webpub.core.tests.WebpubTestPlugin;
import com.narucy.webpub.ui.tests.UITestUtils;
import com.narucy.webpub.ui.wizards.*;

/**
 * 
 */
public class NewWebProjectWizardTest extends TestCase {
	
	NewWebProjectWizard wizard;
	WizardDialog dialog;
	IWizardPage[] pages;
	
	IProject project;
	
	protected void setUp() throws Exception {
		wizard = new NewWebProjectWizard();
		wizard.init(PlatformUI.getWorkbench(), null);
		dialog = new WizardDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), wizard);
		
		dialog.setBlockOnOpen(false);
		dialog.open();
		
		pages = wizard.getPages();
	}
	
	public void testSimple() throws Exception{
		Text text = (Text)UITestUtils.findControl(pages[0].getControl(), Text.class);
		text.setText("aaa");
		
		WebProjectStructureWizardPage structurePage = (WebProjectStructureWizardPage)pages[1];
		structurePage.getBlock().setFolderData("a_ht_sources", "b_scripts", "c_public_html");
		
		PresetSelectionWizardPage presetPage = (PresetSelectionWizardPage)pages[2];
		presetPage.setSelectionIndex(0);
		assertEquals("Empty", presetPage.getSelectedPreset().getName());
		
		assertTrue( wizard.performFinish() );
		
		WebProject wp = (WebProject)ResourcesPlugin.getWorkspace().getRoot().getProject("aaa").getNature(WebProject.ID_NATURE);
		assertEquals("a_ht_sources", wp.getString(WebProject.KEY_HTSOURCES_FOLDER));
		assertEquals("b_scripts", wp.getString(WebProject.KEY_SCRIPTS_FOLDER));
		assertEquals("c_public_html", wp.getString(WebProject.KEY_PUBLISH_FOLDER));
		
		project = wp.getProject();
		assertTrue(project.getFile("a_ht_sources/index.html").exists());
		assertTrue(project.getFile("c_public_html/index.html").exists());
	}
	
	public void testCorp() throws Exception {
		Text text = (Text)UITestUtils.findControl(pages[0].getControl(), Text.class);
		text.setText("bbb");
		
		WebProjectStructureWizardPage structurePage = (WebProjectStructureWizardPage)pages[1];
		structurePage.getBlock().setFolderData("src", "rbs", "pub");
		
		PresetSelectionWizardPage presetPage = (PresetSelectionWizardPage)pages[2];
		presetPage.setSelectionIndex(1);
		assertEquals("Company", presetPage.getSelectedPreset().getName());
		
		assertTrue( wizard.performFinish() );

		WebProject wp = (WebProject)ResourcesPlugin.getWorkspace().getRoot().getProject("bbb").getNature(WebProject.ID_NATURE);
		project = wp.getProject();
		assertTrue(project.getFile("src/home.html").exists());
		assertTrue(project.getFile("pub/home.html").exists());
	}

	protected void tearDown(){
		dialog.close();
		if(project != null){
			WebpubTestPlugin.forceDelete(project);
			project = null;
		}
	}
}
