/*
 * $Id: WorkbenchTocAdapterFactory.java,v 1.3 2004/04/25 00:42:25 hn Exp $
 * Copyright Narushima Hironori. All rights reserved.
 */
package com.narucy.webpub.ui;

import java.net.*;

import org.eclipse.core.resources.*;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.model.IWorkbenchAdapter;

import com.narucy.webpub.core.toc.Topic;

/**
 * 
 */
public class WorkbenchTocAdapterFactory implements IAdapterFactory {

	IWorkbenchAdapter workbenchAdapter = new IWorkbenchAdapter() {
		
		public Object[] getChildren(Object topic) {
			return ((Topic)topic).getSubtopics();
		}

		public ImageDescriptor getImageDescriptor(Object object) {
			if( object instanceof Topic){
				return getImageDescriptorAsTopic((Topic)object);
			}
			return null;
		}

		public String getLabel(Object topic) {
			Topic t = (Topic)topic;
			String label = t.getLabel();
			return label != null ? label : "!!Untitled!!";
		}
		
		public Object getParent(Object topic) {
			return ((Topic)topic).getParent();
		}
		
		ImageDescriptor getImageDescriptorAsTopic(Topic topic){
			IResource res = (IResource)topic.getAdapter(IResource.class);
			if(res != null){
				return ((IWorkbenchAdapter)res.getAdapter(IWorkbenchAdapter.class)).getImageDescriptor(res);
			} else if(topic.getHref() == null){
				return WebpubUIPlugin.getDefault().getWorkbench().getSharedImages().getImageDescriptor(ISharedImages.IMG_OBJ_FOLDER);
			} else if(isURL(topic.getHref())){
				return WebpubUIPlugin.getImageDescriptor("obj16/wwwicon.gif");
			} else{
				return WebpubUIPlugin.getImageDescriptor("obj16/unknown.gif");
			}
		}
	};

	static boolean isURL(String href){
		try {
			new URL(href);
			return true;
		} catch (MalformedURLException e) {
		}
		return false;
	}

	public Object getAdapter(Object adaptableObject, Class adapterType) {
		if(IWorkbenchAdapter.class.equals(adapterType) ){
			return workbenchAdapter;
		}
		return null;
	}

	public Class[] getAdapterList() {
		return new Class[]{ IWorkbenchAdapter.class };
	}

}
