/*
 * $Id: RepublishAction.java,v 1.6 2004/04/27 00:03:46 hn Exp $
 * Copyright Narushima Hironori. All rights reserved.
 */
package com.narucy.webpub.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;

import org.eclipse.core.resources.*;
import org.eclipse.core.runtime.*;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.*;
import org.eclipse.ui.*;

import com.narucy.webpub.core.WebProject;
import com.narucy.webpub.core.publish.SourceFileSeeker;
import com.narucy.webpub.ui.WebpubUIPlugin;

/**
 * 
 */
public class RepublishAction implements IWorkbenchWindowActionDelegate, IWorkspaceRunnable {

	IWorkbenchWindow window;
	ISelection selection;

	public void init(IWorkbenchWindow window) {
		this.window = window;
	}
	
	final public void run(IAction act) {
		if(WebpubUIPlugin.getDefault().getPreferenceStore().getBoolean(WebpubUIPlugin.PUBLISH_BACKGROUND)){
			runInBackground();
		}else{
			runInWorkbenchWindow();
		}
	}
	
	void runInBackground(){
		Job job = new Job("Republish"){

			protected IStatus run(IProgressMonitor monitor) {
				IStatus result = Status.OK_STATUS;
				try{
					RepublishAction.this.run(monitor);
				}catch(CoreException ex){
					result = ex.getStatus();
				}
				return result;
			}
			
		};
		job.schedule();
	}
	
	void runInWorkbenchWindow(){
		try{
			window.run(true, true, new IRunnableWithProgress() {
				public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
					try {
						ResourcesPlugin.getWorkspace().run(RepublishAction.this, monitor);
					} catch (CoreException e) {
						WebpubUIPlugin.handleException(e);
					}
				}
			});
		}
		catch(InvocationTargetException e){
			WebpubUIPlugin.handleException(e);
		}catch(InterruptedException e){
			WebpubUIPlugin.handleException(e);
		}
	}

	public void run(IProgressMonitor monitor) throws CoreException {
		monitor.beginTask("publish resources", 1000);
		try{
			final IResource[] resources = getSelectedResource();
			ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable() {
				public void run(IProgressMonitor monitor) throws CoreException {
					monitor.beginTask("touch resources", resources.length);
					try{
						for (int i=0; i<resources.length; i++) {
							resources[i].touch(new SubProgressMonitor(monitor, 1));
						}
					}finally{
						monitor.done();
					}
				}
			}, new SubProgressMonitor(monitor, 50));
			IProject[] projs = getProjects(resources);
			for (int i = 0; i < projs.length; i++) {
				projs[i].build(IncrementalProjectBuilder.INCREMENTAL_BUILD, new SubProgressMonitor(monitor, 950 / projs.length));
			}
		}finally{
			monitor.done();
		}
	}

	public void selectionChanged(IAction action, ISelection selection) {
		this.selection = selection;
		try {
			action.setEnabled(getSelectedResource().length > 0);
		} catch (CoreException e) {
			action.setEnabled(false);
			WebpubUIPlugin.handleException(e);
		}
	}

	/**
	 * If selected resource contained in publish folder, transration to publish
	 * source resources.
	 */
	protected IResource[] getSelectedResource() throws CoreException {
		ArrayList pubFolders = new ArrayList();
		WebProject[] wps = WebProject.getWebProjects();
		for (int i = 0; i < wps.length; i++) {
			IContainer pubFolder = wps[i].getFolder(WebProject.KEY_PUBLISH_FOLDER);
			if(!pubFolders.contains(pubFolder)){
				pubFolders.add(pubFolder);
			}
		}
		
		Object[] items = null;
		if(selection instanceof IStructuredSelection){
			items = ((IStructuredSelection)selection).toArray();
		}else{
			IEditorPart editor = window.getActivePage().getActiveEditor();
			if(editor != null){
				IEditorInput input = editor.getEditorInput();
				if(input instanceof IFileEditorInput){
					items = new Object[]{ ((IFileEditorInput)input).getFile() };
				}
			}
		}
		
		ArrayList resources = new ArrayList();
		for (int i=0; items != null && i<items.length; i++) {
			IResource res = null;
			
			Object item = items[i];
			if(!(res instanceof IResource) && item instanceof IAdaptable){
				IAdaptable adaptable = (IAdaptable)item;
				res = (IResource)adaptable.getAdapter(IResource.class);
			}
			if(res != null){
				for(IContainer p = res.getParent(); !(p instanceof IWorkspaceRoot); p = p.getParent() ){
					if( pubFolders.contains(p) ){
						res = res instanceof IFile ? SourceFileSeeker.findSource((IFile)res) : null;
						break;
					}
				}
			}
			if(res != null){
				if(!resources.contains(res)){
					resources.add(res);
				}
			}
		}
		
		return (IResource[])resources.toArray(new IResource[resources.size()]);
	}
	
	protected static IProject[] getProjects(IResource[] resources){
		ArrayList projects = new ArrayList();
		for (int i = 0; i < resources.length; i++) {
			IProject proj = resources[i].getProject();
			if(proj != null && !projects.contains(proj)){
				projects.add(proj);
			}
		}
		return (IProject[])projects.toArray(new IProject[projects.size()]);
	}
	
	public void dispose() {
	}

}
