/*
 * $Id: RepublishAllAction.java,v 1.3 2004/04/27 00:03:46 hn Exp $
 * Copyright Narushima Hironori. All rights reserved.
 */
package com.narucy.webpub.ui.actions;

import java.lang.reflect.InvocationTargetException;

import org.eclipse.core.resources.*;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.*;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.*;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;

import com.narucy.webpub.core.WebProject;
import com.narucy.webpub.ui.WebpubUIPlugin;

/**
 * 
 */
public class RepublishAllAction extends RepublishAction {

	public void run(IProgressMonitor monitor) throws CoreException {
		try{
			WebProject[] webProjects = WebProject.getWebProjects();
			monitor.beginTask("republish all project", webProjects.length);
			for (int i = 0; i < webProjects.length; i++) {
				webProjects[i].getProject().build(IncrementalProjectBuilder.FULL_BUILD, new SubProgressMonitor(monitor, 1, SubProgressMonitor.SUPPRESS_SUBTASK_LABEL));
			}
		}finally{
			monitor.done();
		}
	}
	
	public void selectionChanged(IAction action, ISelection selection) {
		// override for always enable
	}

}