/*
 * $Id: RepublishProjectAction.java,v 1.1 2004/04/27 00:03:46 hn Exp $
 * Copyright Narushima Hironori. All rights reserved.
 */
package com.narucy.webpub.ui.actions;

import org.eclipse.core.resources.*;
import org.eclipse.core.runtime.*;

/**
 * 
 */
public class RepublishProjectAction extends RepublishAction {

	public void run(IProgressMonitor moni) throws CoreException {
		try{
			IProject[] projs = getProjects( getSelectedResource() );
			moni.beginTask("republish project", projs.length);
			
			for (int i=0; i<projs.length; i++) {
				projs[i].build(IncrementalProjectBuilder.FULL_BUILD, new SubProgressMonitor(moni, 1, SubProgressMonitor.SUPPRESS_SUBTASK_LABEL));
			}
		}finally{
			moni.done();
		}
	}

}
