/*
 * $Id: TemplateResearchAction.java,v 1.3 2004/04/20 06:57:03 hn Exp $
 * Copyright Narushima Hironori. All rights reserved.
 */
package com.narucy.webpub.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.*;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.*;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.*;
import org.eclipse.ui.*;

import com.narucy.webpub.core.*;
import com.narucy.webpub.ui.WebpubUIPlugin;

/**
 * 
 */
public class TemplateResearchAction implements IWorkbenchWindowActionDelegate {

	IWorkbenchWindow window;
	ISelection selection;

	public void init(IWorkbenchWindow window) {
		this.window = window;
	}

	public void run(IAction action) {
		IRunnableWithProgress operation = new IRunnableWithProgress() {
			public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
				research(monitor);
			}
		};
		try{
			new ProgressMonitorDialog(window.getShell()).run(true, true, operation);	
		}
		catch(InvocationTargetException e){
			e.getCause().printStackTrace();
			handleException(e);
		}
		catch(InterruptedException e){
			handleException(e);
		}
	}
	
	public void research(IProgressMonitor monitor){
		if(monitor == null){
			monitor = new NullProgressMonitor();
		}
		WebProject[] webProjs = getProjectAsSelection();
		monitor.beginTask("Search HTML doucment templates", webProjs.length);
		try{
			for (int i = 0; i < webProjs.length; i++) {
				webProjs[i].getTemplateManager().researchAll(new SubProgressMonitor(monitor, 1));
			}
		} catch (CoreException e) {
			handleException(e);
		} finally{
			monitor.done();
		}
	}
	
	WebProject[] getProjectAsSelection() {
		ArrayList webProjects = new ArrayList();
		if(selection instanceof IStructuredSelection){
			Object[] objs = ((IStructuredSelection)selection).toArray();
			for (int i = 0; i < objs.length; i++) {
				Object obj = objs[i];
				if(obj instanceof IAdaptable){
					IResource resource = (IResource)((IAdaptable)obj).getAdapter(IResource.class);
					if(resource != null){
						try{
							WebProject wp = (WebProject)resource.getProject().getNature(WebProject.ID_NATURE);
							if(wp != null && !webProjects.contains(wp)){
								webProjects.add(wp);
							}
						}catch(CoreException e){
							WebpubPlugin.handleException(e);
						}
					}
				}
			}
		}
		return (WebProject[]) webProjects.toArray(new WebProject[webProjects.size()]);
	}

	public void selectionChanged(IAction action, ISelection selection) {
		this.selection = selection;
		action.setEnabled(getProjectAsSelection().length > 0);
	}

	protected void handleException(Exception e){
		e.printStackTrace();
		IStatus status = new Status(
			IStatus.ERROR,
			WebpubUIPlugin.ID_PLUGIN,
			0,
			e.getMessage(),
			e);
		
		ErrorDialog.openError(
			window.getShell(),
			"Publish Error",
			"Error occase in publishing a html documents or coping files", status);
	}

	public void dispose() {
	}
}
