/*
 * $Id: HTScanner.java,v 1.1 2004/04/11 08:23:38 hn Exp $
 * Copyright Narushima Hironori. All rights reserved.
 */
package com.narucy.webpub.ui.editors.html;

import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.*;
import org.eclipse.jface.util.*;

import com.narucy.webpub.ui.WebpubUIPlugin;
import com.narucy.webpub.ui.editors.ColorManager;

class HTScanner extends BufferedRuleBasedScanner implements IPropertyChangeListener {

	ColorManager manager;
	Token procToken, defaultToken;

	public HTScanner(ColorManager manager) {
		this.manager = manager;
		initToken();

		IRule[] rules = new IRule[2];
		
		// Add rule for processing instructions
		rules[0] = new SingleLineRule("<?", "?>", procToken);
		// Add generic whitespace rule.
		rules[1] = new WhitespaceRule(new HTWhitespaceDetector());
		
		setRules(rules);
		
		setDefaultReturnToken(defaultToken);
	}
	
	private void initToken(){
		TextAttribute attr = new TextAttribute(manager.getColor(WebpubUIPlugin.HT_EDITOR_COLOR_PROCESSOR));
		if(procToken == null){
			procToken = new Token(attr);
		}else{
			procToken.setData(attr);
		}
		attr = new TextAttribute(
			manager.getColor(WebpubUIPlugin.HT_EDITOR_COLOR_DEFAULT));
		if(defaultToken == null){
			defaultToken = new Token(attr);
		}else{
			defaultToken.setData(attr);
		}
	}

	public void propertyChange(PropertyChangeEvent event) {
		String prop = event.getProperty();
		if(prop.equals(WebpubUIPlugin.HT_EDITOR_COLOR_PROCESSOR) || prop.equals(WebpubUIPlugin.HT_EDITOR_COLOR_DEFAULT)){
			initToken();
		}
	}

}
