package com.narucy.webpub.ui.preferences;

import org.eclipse.jface.preference.*;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.*;
import org.eclipse.ui.*;

import com.narucy.webpub.ui.WebpubUIPlugin;

/**
 * @see PreferencePage
 */
public class PublishPreferencePage extends FieldEditorPreferencePage implements IWorkbenchPreferencePage {
	
	public PublishPreferencePage(){
		super(GRID);
		setPreferenceStore(WebpubUIPlugin.getDefault().getPreferenceStore());
	}

	protected void createFieldEditors() {
		final Composite parent = getFieldEditorParent();
		addField(new BooleanFieldEditor(
			WebpubUIPlugin.PUBLISH_BACKGROUND,
			"Publish command process in background",
			parent));
	}

	public void init(IWorkbench workbench) {
	}
	
}
