package com.narucy.webpub.ui.properties;

import java.io.IOException;
import java.util.*;

import org.eclipse.core.resources.*;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.*;
import org.eclipse.swt.layout.*;
import org.eclipse.swt.widgets.*;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.dialogs.PropertyPage;

import com.narucy.webpub.core.WebProject;
import com.narucy.webpub.core.publish.*;
import com.narucy.webpub.ui.WebpubUIPlugin;

/**
 * PublishDescriptionPage.
 */
public class PublishDescriptionPage extends PropertyPage implements IWorkbenchPropertyPage {

	IResource targetResource;
	PublishDescriptionFactory factory;
	
	public PublishDescriptionPage() {
	}
	
	Control createPublishDescriptorErrorControl(Composite parent, Exception e){
		Label label = new Label(parent, SWT.NONE);
		label.setText(e.toString());
		return label;
	}
	
	protected Control createContents(Composite parent)  {
		targetResource = (IResource)getElement().getAdapter(IResource.class);

		try{
			WebProject webProject = (WebProject)targetResource.getProject().getNature(WebProject.ID_NATURE);
			factory = webProject.getPublishDescriptionFactory();
			
			PublishDescription desc = factory.create(targetResource);
			if(desc != null){
				return createPublishInfo(desc, parent);
			}
		}catch(CoreException e){
			WebpubUIPlugin.handleException(e);
		}catch(IllegalConfigurationException e){
			WebpubUIPlugin.handleException(e);
		} catch (IOException e) {
			WebpubUIPlugin.handleException(e);
		}
		
		return createNoPublishInfo(parent);
	}

	/**
	 * No published resource when call for create control.
	 */	
	Control createNoPublishInfo(Composite parent){
		Label labe = new Label(parent, SWT.NONE);
		labe.setText("No Publish.");
		return labe;
	}
	
	Control createPublishInfo(PublishDescription desc, Composite parent) throws CoreException, IOException {
		Composite base = new Composite(parent, SWT.NONE);
		base.setLayout(new GridLayout(3, false));
		
		IFile descFile = (targetResource instanceof IFile && factory.createFromFile((IFile)targetResource) != null) ?
			(IFile)targetResource :
			factory.findMatchDefinition(targetResource).getPropertyFile();
		
		createPublishDescriptorLocationInfo(base, descFile);
		createByInfo( base, desc.getPublishBy());
		createToInfo( base, desc.getPublishTo());
		createArgumentInfo( base, desc.getArguments());
		
		return base;
	}
	
	void createArgumentInfo(Composite base, Map m){
		new Label(base, SWT.NONE).setText("Arguments:");
		Object[] ks = m.keySet().toArray();
		if( ks.length > 0){
			Arrays.sort(ks);
			for (int j = 0; j < ks.length; j++) {
				if( j != 0){
					new Label(base, SWT.NONE);
				}
				String k = (String)ks[j];
				new Label(base, SWT.NONE).setText(k + ":");
				new Label(base, SWT.NONE).setText(m.get(k).toString() );
			}
		}
	}

	void createByInfo(Composite base, String by){
		createLineLabel(base, "Publish By", by);
	}

	void createPublishDescriptorLocationInfo(Composite base, final IFile pubDescFile){
		boolean descFileExist = (pubDescFile != null);
		
		String val = descFileExist ? pubDescFile.getFullPath().toString() : "(none)";
		createLineLabel(base, "Publish Descriptor Location", val);
		
		Button button = new Button(base, SWT.NONE);
		GridData gd = new GridData();
		gd.horizontalSpan = 3;
		button.setLayoutData(gd);
		button.setText("&Publish Descriptor Definication");
		button.addSelectionListener( new SelectionListener() {
			public void widgetSelected(SelectionEvent e) {
				PublishDescriptorDefinitionPage.openPublishDescriptorDefinicationDialog(pubDescFile, getShell());
			}
			public void widgetDefaultSelected(SelectionEvent e) {}
		});
		button.setEnabled(descFileExist && pubDescFile.getName().equals(".publish"));
	}
			
	void createLineLabel(Composite base, String name, String value){
		new Label(base, SWT.NONE).setText(name + ":");
		Label labe = new Label(base, SWT.NONE);
		GridData gd = new GridData();
		gd.horizontalSpan = 2;
		labe.setLayoutData(gd);
		labe.setText(value);
	}
	
	void createToInfo(Composite base, IResource to){
		createLineLabel(base, "Publish To", to.getFullPath().toString());
	}

}
