/*
 * $Id: TemplateManagerViewer.java,v 1.3 2004/04/20 06:57:03 hn Exp $
 * Copyright Narushima Hironori. All rights reserved.
 */
package com.narucy.webpub.ui.views;

import java.util.HashMap;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.*;
import org.eclipse.jface.viewers.*;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.*;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.*;

import com.narucy.webpub.core.WebProject;
import com.narucy.webpub.core.template.*;

class GlobalTemplateManagerContentProvider implements ITreeContentProvider {

	TemplateManager[] templateManagers;
	
	public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
		if(newInput instanceof WebProject[]){
			templateManagers = toTemplateManagers( (WebProject[])newInput );
		}
	}
	
	TemplateManager[] toTemplateManagers(WebProject[] wps){
		TemplateManager[] templateMgrs = new TemplateManager[wps.length];
		for (int i = 0; i < wps.length; i++) {
			templateMgrs[i] = wps[i].getTemplateManager();
		}
		return templateMgrs;
	}

	public Object[] getChildren(Object parent) {
		if(parent instanceof WebProject[]){
			return toTemplateManagers( (WebProject[])parent);
		}else if(parent instanceof TemplateManager){
			return ((TemplateManager)parent).getGlobalTemplates();
		}else if (parent instanceof Template){
			Template tmpl = (Template)parent;
			return getParentTemplateManager(tmpl).getTemplateDefinedFiles(tmpl.getName());
		}
		return null;
	}

	TemplateManager getParentTemplateManager(Template tmpl){
		for (int i = 0; i < templateManagers.length; i++) {
			Template[] tmpls = templateManagers[i].getGlobalTemplates();
			for (int j = 0; j < tmpls.length; j++) {
				if(tmpls[j].equals(tmpl)){
					return templateManagers[i];
				}
			}
		}
		return null;
	}
	
	public Object getParent(Object element) {
		if (element instanceof Template){
			return getParentTemplateManager((Template)element);
		}
		if(element instanceof IFile){
			for (int i = 0; i < templateManagers.length; i++) {
				TemplateManager tmplMgr = templateManagers[i];
				if( tmplMgr.getWebProject().getProject().equals((IFile)element) ){
					return tmplMgr;
				}
			}
		}
		return null;
	}

	public boolean hasChildren(Object element) {
		return getChildren(element) != null;
	}

	public void dispose() {
	}

	public Object[] getElements(Object inputElement) {
		return getChildren(inputElement);
	}

}

/**
 * TemplateManagerViewer.
 */
public class TemplateManagerViewer extends TableTreeViewer {
	
	final public static String
		NAME = "name",
		DESCRIPTION = "description";
	
	final static String[] defaultColumn = {
		NAME,
		DESCRIPTION 
	};

	HashMap columnNames = new HashMap();
	
	class TemplateLabelProvider extends LabelProvider implements ITableLabelProvider {

		public Image getColumnImage(Object element, int columnIndex) {
			return null;
		}

		public String getColumnText(Object element, int colIndex) {
			String text = "";
			if(element instanceof TemplateManager){
				TemplateManager tmplMgr = (TemplateManager)element;
				if(colIndex == 0){
					text = tmplMgr.getWebProject().getProject().getName();
				}
			}else if( element instanceof Template){
				Template tmpl = (Template)element;
				if(colIndex == 0){
					text = tmpl.getName();
				}else if(colIndex == 1){
					text = "Length:" + tmpl.getJoinedLines().length();
				}
			} else if(element instanceof IFile){
				IFile f = (IFile)element;
				if(colIndex == 0){
					int cutSegument = 0;
					try{
						WebProject wp = (WebProject)f.getProject().getProject().getNature(WebProject.ID_NATURE);
						if(wp != null){
							cutSegument = wp.getFolder(WebProject.KEY_HTSOURCES_FOLDER).getFullPath().segmentCount();
						}
					}catch(CoreException e){
					}
					text = f.getFullPath().removeFirstSegments(cutSegument).toString();
				}
			}
			return text;
		}
	
		public boolean isLabelProperty(Object element, String property) {
			Object[] columnProperties = getColumnProperties();
			for(int i=0; i<columnProperties.length; i++){
				if( columnProperties[i].equals(property) ){
					return true;
				}
			}
			return false;
		}

		public void dispose() {
		}

	}

	public TemplateManagerViewer(Composite parent) {
		super(parent, SWT.SINGLE | SWT.FULL_SELECTION);
		columnNames.put(NAME, "Name");
		columnNames.put(DESCRIPTION, "Description");
		
		// init column properties
		setContentProvider(new GlobalTemplateManagerContentProvider() );
		setLabelProvider(new TemplateLabelProvider());
		
		String[] columnProperties = (String[])defaultColumn.clone();
		setColumnProperties(columnProperties);
		
		// init table
		Table table = getTableTree().getTable();
		for (int i = 0; i < columnProperties.length; i++) {
			String key = columnProperties[i];
			TableColumn col = new TableColumn(table, SWT.NONE);
			col.setText( (String)columnNames.get(key) );
		}
		table.setHeaderVisible(true);
		table.setLinesVisible(true);
		
		for (int i = 0; i < table.getColumnCount(); i++) {
			table.getColumn(i).pack();
		}
	}
	
	Template getCurrentSelectionTemplate(){
		TableTree tableTree = getTableTree();
		TableTreeItem item = tableTree.getSelection()[0];
		
		Item itm = getParentItem(item);
		if( itm != null){
			Object data = itm.getData();
			if( data instanceof Template){
				return (Template)data;
			}
		}
		return null;
	}
	
	static int beginTmplLineNumber(IDocument doc, String tmplName) throws BadLocationException{
		for(int i=0, lineCount = doc.getNumberOfLines(); i<lineCount; i++){
			IRegion region = doc.getLineInformation(i);
			String line = doc.get(region.getOffset(), region.getLength());
			if( tmplName.equals(TemplateParser.matchBeginTmplateLine(line)) ){
				return i;
			}
		}
		return -1;
	}

}

