/*
 * $Id: TocView.java,v 1.3 2004/04/25 00:42:25 hn Exp $
 * Copyright Narushima Hironori. All rights reserved.
 */
package com.narucy.webpub.ui.views;

import org.eclipse.core.resources.*;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.*;
import org.eclipse.ui.*;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.views.navigator.ResourceNavigator;

import com.narucy.webpub.core.toc.Topic;

/**
 * SitemapView
 */
public class TocView extends ResourceNavigator {

	public void setFocus() {
	}

	protected void makeActions() {
		setActionGroup(new TocActionGroup(this));
	}
	
	protected IStructuredSelection convertTocToFile(IStructuredSelection sel){
		Object[] selItems = sel.toArray();
		for(int i=0; i<selItems.length; i++){
			Object item = selItems[i];
			if(item instanceof IAdaptable){
				Object file = ((IAdaptable)item).getAdapter(IResource.class);
				if(file instanceof IFile){
					selItems[i] = file;
				}
			}
		}
		return new StructuredSelection(selItems);
	}

	protected IStructuredSelection convertFileToToc(IStructuredSelection selection){
		Object[] selItems = ((IStructuredSelection)selection).toArray();
		for (int i = 0; i < selItems.length; i++) {
			Object item = selItems[i];
			if(item instanceof IFile){
				Topic t = (Topic)((IFile)item).getAdapter(Topic.class);
				if(t != null){
					selItems[i] = t;
				}
			}
		}
		return new StructuredSelection(selItems);
	}
	
	protected void handleOpen(OpenEvent event) {
		IStructuredSelection sel = (IStructuredSelection) event.getSelection();
		getActionGroup().runDefaultAction( convertTocToFile(sel) );
	}

	protected void linkToEditor(IStructuredSelection selection) {
		super.linkToEditor( convertTocToFile(selection) );
	}

	protected void editorActivated(IEditorPart editor) {
		if (!isLinkingEnabled()) {
			return;
		}
		IEditorInput input = editor.getEditorInput();
		if (input instanceof IFileEditorInput) {
			IFileEditorInput fileInput = (IFileEditorInput) input;
			IFile file = fileInput.getFile();
			Topic topic = (Topic)file.getAdapter(Topic.class);
			
			if( topic != null){
				ISelection newSelection = new StructuredSelection(topic);
				if (!getTreeViewer().getSelection().equals(newSelection)) {
					getTreeViewer().setSelection(newSelection);
				}
			}
		}
	}

	protected void initContentProvider(TreeViewer viewer) {
		viewer.setContentProvider(new TocContentProvider() );
	}

	protected void fillContextMenu(IMenuManager menu) {
		IStructuredSelection sel = convertTocToFile((IStructuredSelection)getViewer().getSelection());
		
		getActionGroup().setContext(new ActionContext(sel));
		getActionGroup().fillContextMenu(menu);
	}

	public void saveState(IMemento memento) {
		// super.saveState(memento);
	}

}
	
