require 'amritatmpl/navipage'
require 'lib/rdf'

class SelfLinkFilter < Webpub::HTFilter

	def initialize
		@after = '<span class="selfpage">\1</span>'
	end

	def filter(desc, lines)
		lines.gsub(
			%r!<a\s+href="#{File.basename desc.publish_to}".*?>(.+?)</a>!,
			@after)
	end

end


class Base < NaviPage

	def initialize(desc)
		super(desc)
		@begining = Time.gm(2003, 8, 30)
		desc.ht_filters << SelfLinkFilter.new
	end

	def last_update
		strftime(Time.now)
	end
	
	def strftime(time)
		time = Time.parse(time) unless time.is_a?(Time)
		time.strftime('%Y.%m.%d')
	end

	def years
		now = Time.now
		@begining.year == now.year ?  now.year.to_s : "#{@begining.year}-#{now.year}"
	end

	def para( msg)
		Amrita::SanitizedString[ '<p>' + msg.split(%r!\n\n+!).join('</p><p>') + '</p>']
	end

end
