require 'test/unit'
require 'time'

class RDFTest < Test::Unit::TestCase
	
	def setup
		$: << File.dirname(__FILE__) + '/..'
		require 'lib/rdf'
	end
	
	def test_read
		rdf = RDF.instance(File.dirname(__FILE__) + '/test.rdf')
		
		assert_equal('Your Company Homepage', rdf.title)
		assert_equal('http://www.yourcompany.com', rdf.url)
		assert_equal('Your company concepts description', rdf.description)
		
		items = rdf.to_a
		assert_equal(3, items.size)
		
		assert_equal(Time.parse('2004-01-03'), items[0][:date])
		assert_equal('title 3', items[0][:title])
		assert_equal('http://www.yourcompany.com/3.html', items[0][:url])
		
		assert_equal(Time.parse('2004-01-01'), items[1][:date])
		assert_equal('title 1', items[1][:title])
		assert_equal('http://www.yourcompany.com/1.html', items[1][:url])
		
		assert_equal(Time.parse('2004-01-02'), items[2][:date])
		assert_equal('title 2', items[2][:title])
		assert_equal('http://www.yourcompany.com/2.html', items[2][:url])
	end
	
end
