# $Id: sitemap.rb,v 1.1 2004/01/17 12:02:33 hn Exp $
# Copyright Narushima Hironori. All rights reserved.

require 'base'
require 'amrita/format'
require 'sitemapper/navigation'
require 'sitemapper/generator'

class Sitemap < Base

	def sitemap
		wp = @description.web_project
		
		mapfile = File.join( wp.project_path, 'toc.xml')
		rel_dir = @description.publish_to.gsub(/#{wp[:publish_dir]}/, '')
		
		line = SiteMapper::SitemapGenerator.new(rel_dir).gen(mapfile)
		Amrita::SanitizedString[line]
	end

end
