#
# $Id: navigatable_page.rb,v 1.1 2004/01/17 12:02:34 hn Exp $
# Copyright Narushima Hironori. All rights reserved.
#

require 'amrita/node_expand'
require 'amrita/template'
require 'sitemapper/navigation'

class AbstractPage < Hash

	def []=(key, value)
		key = key.intern if key.is_a?(String)
		store(key, value)
	end

	def [](key)
		key = key.intern if key.is_a?(String)
		return send(key) if respond_to?(key)
		return fetch(key) if key?(key)
		
		handle_error(key)
	end
	
	def handle_error(key)
		puts "key not found: #{key}"
	end

end

class NaviPage < AbstractPage

	def initialize( desc, tocfile = nil)
		super()
		
		@description = desc
		wp = desc.web_project
		
		unless tocfile
			raise ArgumentError, "#{wp.path} is not contain toc file entry" unless wp[:toc_pathes]
			tocfile = File.join(wp.path, wp[:toc_pathes].split[0])
		end
		@tocfile = tocfile
		
		@navigation_factory = SiteMapper::NavigatorFactory.instance(tocfile)
		rel_path = desc.publish_to.sub(/^#{wp[:publish_dir]}/, '')
		
		links = @navigation_factory.create_by_path(rel_path)
		if links
			SiteMapper::NavigatorFactory::NAVI_KEYS.each { |k|
				k_title = (k.to_s + '_title').intern
				k_url = (k.to_s + '_url').intern
				
				if links[k]
					self[k] = links[k][:title] ? links[k] : nil
					self[k_title] = links[k][:title]
					self[k_url] = links[k][:url]
				else
					self[k] = self[k_title] = self[k_url] = nil
				end
			}
		end
	end

end
