#
# $Id: delegate_publisher.rb,v 1.6 2004/06/06 22:38:21 hn Exp $
# Copyright Narushima Hironori. All rights reserved.
#

require 'cgi'
require 'fileutils'
require 'webpub/publisher'
require 'webpub/abstorel_filter'

module Webpub

class DelegatePublisher < Publisher

	def publish(desc)
		begin
			args = desc.arguments
			script = args['script']
			unless script
				raise ArgumentError, %Q!must be specify value "script" in argument: #{args}!
			end
			
			klass = args['class']
			unless klass
				raise ArgumentError, %Q!must be specify value "klass" in argument: #{args}!
			end
			
			require script
			eval(klass).new.publish(desc)
			
		rescue Exception
			if @error_distribute and desc.ht_type? and desc.publish_to
				FileUtils.mkdir_p( File.dirname(desc.publish_to) )
				open( desc.publish_to, 'w') { |fh|
					fh << "<bodyi><h4><pre>#{CGI.escapeHTML($!.message)}</pre></h4>"
					fh << %Q!<pre>#{CGI.escapeHTML($!.backtrace.join("\n"))}</pre>!
					fh << '</body>'
				}
			end
			raise $!.class, $!.message, $!.backtrace
		end
	end
	
end

end
