#
# $Id: erb_publisher.rb,v 1.6 2004/06/05 00:00:07 hn Exp $
# Copyright Narushima Hironori. All rights reserved.
#

require 'cgi'
require 'erb'
require 'webpub/publisher'
require 'webpub/abstorel_filter'

module Webpub

class ERBPublisher < Publisher

	def publish(desc)
		begin
			do_publish(desc)
		rescue Exception => err
			if @error_distribute and desc.ht_type? and desc.publish_to
				open( desc.publish_to.gsub('*', '').gsub('?', ''), 'w') { |fh|
					fh <<
						"<body><h4><pre>#{CGI.escapeHTML(err.message)}</pre></h4>" +
						%Q!<pre>#{CGI.escapeHTML(err.backtrace.join("\n"))}</pre>! +
						'</body>'
				}
			end
			raise err.class, err.message.gsub("\n", ' - '), err.backtrace
		end
	end

	protected

	def do_publish(desc)
		@description = desc
		lines = ERB.new( IO.read(desc.publish_from) ).result
		ht_distribute(desc, lines)
	end

end

end
