/*
 * $Id: ElementWriterTest.java,v 1.6 2004/06/07 06:46:49 hn Exp $
 * Copyright Narushima Hironori. All rights reserved.
 */
package com.narucy.webpub.core.tests;

import java.io.ByteArrayInputStream;

import javax.xml.parsers.DocumentBuilderFactory;

import junit.framework.TestCase;

import org.w3c.dom.*;

import com.narucy.webpub.core.ElementWriter;

/**
 * Tests expand tag and that code is possble to created xml
 * that compare dom object.
 */
public class ElementWriterTest extends TestCase {

	DocumentBuilderFactory builder = DocumentBuilderFactory.newInstance();

	public ElementWriterTest(String arg0) {
		super(arg0);
	}

	public void testExpandTagElement() throws Exception {
		Document doc = builder.newDocumentBuilder().newDocument();
		
		Element from = doc.createElement("form");
		Element dl = doc.createElement("dl");
		from.appendChild(dl);
		
		String[] formValues = {
			"Name", "text", "name",
			"Password", "password", "password",
			"Description", "text","description"
		};
		
		for(int i=0; i<formValues.length; i+=3){
			Element dt = doc.createElement("dt");
			dl.appendChild(dt);
			Text text = doc.createTextNode(formValues[i]);
			dt.appendChild( text );
			
			Element dd = doc.createElement("dd");
			dl.appendChild(dd);
			
			Element input = doc.createElement("input");
			dd.appendChild(input);
			input.setAttribute("name", formValues[i+2]);
			input.setAttribute("type", formValues[i+1]);
			dd.appendChild(input);
		}
		
		ElementWriter writer = new ElementWriter(0, null);
		String xmlCode1 = writer.expandTag(from);
		assertEquals(
			"<form><dl><dt>Name</dt><dd><input name=\"name\" type=\"text\" /></dd><dt>Password</dt><dd><input name=\"password\" type=\"password\" /></dd><dt>Description</dt><dd><input name=\"description\" type=\"text\" /></dd></dl></form>",
			xmlCode1);
		
		
		writer.setExpandOption("form", ElementWriter.BEGIN_CHANGELINE | ElementWriter.END_CHANGELINE );
		String xmlCode2 = writer.expandTag(from);
		assertEquals(
			"<form>\n<dl><dt>Name</dt><dd><input name=\"name\" type=\"text\" /></dd><dt>Password</dt><dd><input name=\"password\" type=\"password\" /></dd><dt>Description</dt><dd><input name=\"description\" type=\"text\" /></dd></dl></form>\n",
			xmlCode2);
		
		writer.setExpandOption("dl", ElementWriter.BEGIN_CHANGELINE | ElementWriter.END_CHANGELINE);
		writer.setExpandOption("dt", ElementWriter.END_CHANGELINE);
		writer.setExpandOption("dd", ElementWriter.END_CHANGELINE);

		String xmlCode3 = writer.expandTag(from);
		assertEquals(
			"<form>\n<dl>\n<dt>Name</dt>\n<dd><input name=\"name\" type=\"text\" /></dd>\n<dt>Password</dt>\n<dd><input name=\"password\" type=\"password\" /></dd>\n<dt>Description</dt>\n<dd><input name=\"description\" type=\"text\" /></dd>\n</dl>\n</form>\n",
			xmlCode3);
		
		
		Document d1 = builder.newDocumentBuilder().parse( new ByteArrayInputStream(xmlCode1.getBytes()) );
		Document d2 = builder.newDocumentBuilder().parse( new ByteArrayInputStream(xmlCode1.getBytes()) );
		Document d3 = builder.newDocumentBuilder().parse( new ByteArrayInputStream(xmlCode1.getBytes()) );

		assertEquals(d1.getDocumentElement(), from);
		assertEquals(d2.getDocumentElement(), from);
		assertEquals(d3.getDocumentElement(), from);
	}
	
	boolean assertEquals(Node e1, Node e2){
		NodeList nl1 = e1.getChildNodes();
		NodeList nl2 = e2.getChildNodes();
		if(nl1.getLength() != nl2.getLength()){
			return false;
		}
		
		for(int i=0; i<nl1.getLength(); i++){
			boolean result = assertEquals(nl1.item(i), nl2.item(i));
			if(!result){
				return false;
			}
		}
		return true;
	}

}
