/*
 * $Id: WebpubPluginTest.java,v 1.13 2004/06/07 06:46:49 hn Exp $
 * Copyright Narushima Hironori. All rights reserved.
 */
package com.narucy.webpub.core.tests;

import java.io.File;

import junit.framework.TestCase;

import org.osgi.framework.Bundle;

import com.narucy.webpub.core.*;

public class WebpubPluginTest extends TestCase {

	public WebpubPluginTest(String arg0) {
		super(arg0);
	}
	
	public void testScriptSideTest() throws Exception {
		Bundle bundle = WebpubTestPlugin.getDefault().getBundle();
		assertNotNull(bundle);
		String testScriptPath = WebpubPlugin.getLocalPath("test_scripts/testall", bundle);
		assertTrue(new File(testScriptPath).isFile());
		
		final Process proc = WebpubPlugin.getDefault().rubyExec(testScriptPath, null);
		final String[] outputs = new String[2];
		Thread stdoutReader = new Thread(){
			public void run(){
				TextReader r = new TextReader(proc.getInputStream());
				try{
					outputs[0] = r.joinedLines();
				}finally{
					r.close();
				}
			}
		};
		Thread stderrReader = new Thread(){
			public void run(){
				TextReader r = new TextReader(proc.getErrorStream());
				try{
					outputs[1] = r.joinedLines();
				}finally{
					r.close();
				}
			}
		};
		stdoutReader.start();
		stderrReader.start();
		while(stdoutReader.isAlive() && stderrReader.isAlive()){
			Thread.sleep(100);
		}
		assertTrue(outputs[0], outputs[0].indexOf("0 failures, 0 errors") != -1);
	}
	
	public void testFindInterpreter() {
		assertNotNull(WebpubPlugin.findInitialInterpreter());
		assertTrue(WebpubPlugin.findInitialInterpreter().toFile().exists());
	}
	
}
