/*
 * $Id: PublishMappingWriterTest.java,v 1.4 2004/06/07 06:46:50 hn Exp $
 * Copyright Narushima Hironori. All rights reserved.
 */
package com.narucy.webpub.core.tests.publish;

import java.io.File;
import java.net.URL;

import javax.xml.parsers.DocumentBuilderFactory;

import junit.framework.TestCase;

import org.eclipse.core.runtime.Path;
import org.w3c.dom.*;

import com.narucy.webpub.core.publish.PublishMappingWriter;
import com.narucy.webpub.core.tests.WebpubTestPlugin;

/**
 * 
 */
public class PublishMappingWriterTest extends TestCase {

	DocumentBuilderFactory docBuilderFac = DocumentBuilderFactory.newInstance();

	public PublishMappingWriterTest(String name) {
		super(name);
	}

	public void testStore() throws Exception {
		String[] propFiles = {
			"ht_sources/folder/.publish",
			"ht_sources/folder/subfolder/.publish",
			"ht_sources/folder/subfolder/subsubfolder/.publish",
			"ht_sources/imgs/.publish",
			"rd/.publish",
			"rd/with_tmpl/.publish",
		};
		
		File tmpFile = WebpubTestPlugin.createTempFile("testStore");
		try{
			for (int i = 0; i < propFiles.length; i++) {
				URL url = WebpubTestPlugin.getDefault().find(new Path("test_scripts/webpub/test_workspace/web_project/" + propFiles[i]));
				
				Document doc = docBuilderFac.newDocumentBuilder().parse(url.openStream());
				PublishMappingWriter.store(tmpFile, doc);
				Document doc2 = docBuilderFac.newDocumentBuilder().parse(tmpFile);
				
				NodeList list = doc.getDocumentElement().getElementsByTagName("mapping");
				NodeList list2 = doc2.getDocumentElement().getElementsByTagName("mapping");
				assertEquals(list.getLength(), list2.getLength());
				for(int j=0; j<list.getLength(); j++){
					assertEquals( list.item(j).toString(), list2.item(j).toString());
				}
			}
		}finally{
			tmpFile.delete();
		}
	}

}
