/*
 * $Id: TemplateTest.java,v 1.4 2004/06/07 06:46:51 hn Exp $
 * Copyright Narushima Hironori. All rights reserved.
 */
package com.narucy.webpub.core.tests.template;

import junit.framework.TestCase;

import com.narucy.webpub.core.template.*;

/**
 * 
 */
public class TemplateTest extends TestCase {

	public TemplateTest(String arg0) {
		super(arg0);
	}
	
	public void testModify() throws Exception{
		// simple
		Template tmplFrom = createTemplate("Template-1_simple_from");
		Template tmplTo = createTemplate("Template-1_simple_to");
		
		tmplTo.modifyTmpl(tmplFrom);
		assertEquals("AAA", tmplTo.getLines()[1]);
		
		// structual
		tmplFrom = createTemplate("Template-2_structual_from");
		tmplTo = createTemplate("Template-2_structual_to");
		
		tmplTo.modifyTmpl(tmplFrom);
		String[] lines = tmplTo.getLines();
		assertEquals("AAA", lines[1]);
		assertEquals("BBB", lines[3]);
		assertEquals("CCC", lines[5]);
		
		// multiple template modify
		tmplFrom = createTemplate("Template-3_multiple_from");
		tmplTo = createTemplate("Template-3_multiple_to");
		
		tmplTo.modifyTmpl(tmplFrom);
		lines = tmplTo.getLines();
		assertEquals("BBB", lines[1]);
		assertEquals("XXX", lines[5]);
		assertEquals("BBB", lines[7]);
		assertEquals("BBB", lines[12]);

		// multiple template modify
		tmplFrom = createTemplate("Template-4_contents_from");
		tmplTo = createTemplate("Template-4_contents_to");

		tmplTo.modifyTmpl(tmplFrom);
		lines = tmplTo.getLines();
		assertEquals("AAA", lines[1]);
		assertEquals("000", lines[3]);
		assertEquals("AAA", lines[8]);
		assertEquals("111", lines[10]);
		assertEquals("AAA", lines[15]);
		assertEquals("222", lines[17]);
		
		// add node
		tmplFrom = createTemplate("Template-5_addnode_from");
		tmplTo = createTemplate("Template-5_addnode_to");

		tmplTo.modifyTmpl(tmplFrom);
		lines = tmplTo.getLines();
		assertEquals("AAA", lines[1]);
		assertEquals("BBB", lines[3]);
		
		// addnode with content
		tmplFrom = createTemplate("Template-6_addnode_contents_from");
		tmplTo = createTemplate("Template-6_addnode_contents_to");
		tmplTo.modifyTmpl(tmplFrom);
		
		lines = tmplTo.getLines();
		assertEquals("A", lines[1]);
		assertEquals("111", lines[3]);
		assertEquals("B", lines[6]);
		assertEquals("NN", lines[8]);
		assertEquals("NNN", lines[12]);

		tmplFrom = createTemplate("Template-7_deletenode_from");
		tmplTo = createTemplate("Template-7_deletenode_to");
		tmplTo.modifyTmpl(tmplFrom);
		
		String joinedLines = tmplTo.getJoinedLines();
		assertEquals(-1, joinedLines.indexOf("<!-- $begin:C$ -->"));
		assertEquals(-1, joinedLines.indexOf("CCC"));
		
		lines = tmplTo.getLines();
		assertEquals("1", lines[3]);
	}
	
	public Template createTemplate(String path) throws Exception {
		TemplateParser parser = new TemplateParser();
		return parser.parse(getClass().getResourceAsStream(path), "UTF-8");
	}
	
	public void testClone(){
		Template tx = new Template(Template.NAME_CONTENTS);
		tx.addLine("line x-1");
		tx.addLine("line x-2");
		tx.addLine("line x-3");
		
		Template ta = new Template("a");
		ta.addLine("line a-1");
		ta.addLine("line a-2");
		
		Template tb = new Template("b");
		tb.addLine("line b-1");
		tb.addTemplate(ta);
		tb.addTemplate(tx);
		tb.addTemplate(ta);
		tb.addLine("line b-2");
		
		Template tc = new Template("c");
		tc.addLine("line c-1");
		tc.addTemplate(tb);
		tc.addLine("line c-2");
		
		Template clonedTc = (Template)tc.clone();
		assertNotSame( clonedTc, tc);
		assertEquals( clonedTc, tc);
		assertEquals( clonedTc.getJoinedLines(), tc.getJoinedLines());
		
		Template clonedTb = (Template)tb.clone();
		assertNotSame( clonedTb, tb);
		assertEquals( clonedTb, tb);
		assertEquals( clonedTb.getJoinedLines(), tb.getJoinedLines() );
	}
	
	public void testEqualsWithContent(){
		Template tx = new Template(Template.NAME_CONTENTS);
		tx.addLine("line 1");
		tx.addLine("line 2");
		tx.addLine("line 3");
		
		Template ty = new Template(Template.NAME_CONTENTS);
		ty.addLine("line 4");
		ty.addLine("line 5");
		ty.addLine("line 6");
		assertEquals(tx, ty);
		
		Template ta = new Template("a");
		ta.addLine("line1");
		ta.addTemplate(tx);
		ta.addLine("line2");
		
		Template tb = new Template("a");
		tb.addLine("line1");
		tb.addTemplate(ty);
		tb.addLine("line2");
		
		Template tc = new Template("a");
		tc.addLine("line3");
		tc.addTemplate(ty);
		tc.addLine("line4");

		assertTrue(ta.equals(tb) );
		assertFalse(ta.equals(tc));
	}

	public void testEquals() {
		Template ta = new Template("a");
		ta.addLine("line1");
		ta.addLine("line2");
		
		Template tb = new Template("b");
		tb.addLine("line1");
		tb.addLine("line2");
		
		Template tc = new Template("a");
		tc.addLine("line1");
		tc.addLine("line2");
		
		Template td = new Template("a");
		td.addLine("line1");
		td.addLine("line");

		assertFalse( ta.equals(tb) );
		assertTrue( ta.equals(ta));
		assertTrue( ta.equals(tc));
		assertFalse( ta.equals(td) );
		
		Template te = new Template("e");
		te.addLine("l1");
		te.addTemplate(ta);
		te.addLine("l2");
		te.addLine("l3");
		
		Template tf = new Template("e");
		tf.addLine("l1");
		tf.addTemplate(tc);
		tf.addLine("l2");
		tf.addLine("l3");
		
		assertEquals( te.getJoinedLines(), tf.getJoinedLines() );
		assertTrue( te.equals(tf));
		
		te.addTemplate(tb);
		assertTrue(!te.equals(tf));
	}
	

}
