/*
 * $Id: TocAdapterFactoryTest.java,v 1.10 2004/06/07 06:46:51 hn Exp $
 * Copyright Narushima Hironori. All rights reserved.
 */
package com.narucy.webpub.core.tests.toc;

import java.util.HashMap;

import junit.framework.TestCase;

import org.eclipse.core.resources.*;

import com.narucy.webpub.core.WebProject;
import com.narucy.webpub.core.tests.WebpubTestPlugin;
import com.narucy.webpub.core.toc.*;

/**
 * 
 */
public class TocAdapterFactoryTest extends TestCase {

	public TocAdapterFactoryTest(String name) {
		super(name);
	}
	
	WebProject webProject;
	
	protected void setUp() throws Exception {
		webProject = WebpubTestPlugin.createTestProject("test_scripts/webpub/test_workspace/web_project");
	}

	public void testGetFile() throws Exception{
		IFile tocFile = webProject.getProject().getFile("ht_sources/toc.xml");
		Toc toc = webProject.getToc(tocFile);
		assertEquals(tocFile, toc.getAdapter(IResource.class));
		
		Topic[] topics = toc.getAllTopics();
		assertEquals(topics.length, 20);
		
		HashMap fileLabels = new HashMap();
		for (int i = 0; i < topics.length; i++) {
			Topic topic = (Topic)topics[i];
			if(topic.getAttribute(Topic.HREF) != null){
				IFile f = (IFile)topic.getAdapter(IResource.class);
				assertNotNull(topic.getAttribute(Topic.HREF), f);
				fileLabels.put(f, topic.getLabel());
			}
		}
		
		Object[] fs = fileLabels.keySet().toArray();
		for (int i = 0; i < fs.length; i++) {
			IFile f = (IFile)fs[i];
			Topic t = (Topic)f.getAdapter(Topic.class);
			assertEquals( fileLabels.get(f), t.getLabel());
		}
	}

	protected void tearDown() throws Exception {
		WebpubTestPlugin.forceDelete(webProject.getProject());
	}

}
