/*
 * $Id: TocStoreTest.java,v 1.9 2004/06/07 06:46:51 hn Exp $
 * Copyright Narushima Hironori. All rights reserved.
 */
package com.narucy.webpub.core.tests.toc;

import java.io.*;
import java.net.URL;
import java.util.Arrays;

import junit.framework.TestCase;

import org.eclipse.core.resources.*;
import org.eclipse.core.runtime.Path;

import com.narucy.webpub.core.WebProject;
import com.narucy.webpub.core.tests.WebpubTestPlugin;
import com.narucy.webpub.core.toc.*;

/**
 * 
 */
public class TocStoreTest extends TestCase {

	public TocStoreTest(String arg0) {
		super(arg0);
	}
	
	public void testCharset() throws Exception {
		WebProject[] wps = {
				WebpubTestPlugin.createTestProject("test_projects/TemplateTest-EUC-JP"),
				WebpubTestPlugin.createTestProject("test_projects/TemplateTest-Shift_JIS"),
				WebpubTestPlugin.createTestProject("test_projects/TemplateTest-UTF-8"),
		};
		try{
			for (int i = 0; i < wps.length; i++) {
				WebProject wp = wps[i];
				IFile f = wp.getTocFiles()[0];
				Toc toc = wp.getToc(f);
				
				Topic[] topics = toc.getAllTopics();
				assertEquals(4, topics.length);
				String[] topicLabels = new String[4];
				for (int j = 0; j < topics.length; j++) {
					topicLabels[j] = topics[j].getLabel();
				}
				assertTrue(Arrays.equals(new String[]{"", "", "", ""}, topicLabels));
				topics[0].setLabel("");
				topics[1].setLabel("");
				topics[2].setLabel("");
				topics[3].setLabel("");
				
				TocWriter.storeToc(toc, f);
				f.refreshLocal(IResource.DEPTH_ZERO, null);
				
				toc = wp.getToc(f);
				topics = toc.getAllTopics();
				for (int j = 0; j < topics.length; j++) {
					topicLabels[j] = topics[j].getLabel();
				}
				assertTrue(Arrays.equals(new String[]{"", "", "", ""}, topicLabels));
			}
		}finally{
			for (int i = 0; i < wps.length; i++) {
				WebpubTestPlugin.forceDelete(wps[i].getProject());
			}
		}
	}

	public void testTocStoreTocOutputStream() throws Exception{
		String[] tocFiles = {
			"test_projects/SitemapTest/toc.xml",
			"test_scripts/webpub/test_workspace/web_project/ht_sources/toc.xml",
		};
		
		for (int i = 0; i < tocFiles.length; i++) {
			URL url = WebpubTestPlugin.getDefault().find(new Path(tocFiles[i]));
			Toc toc = TocFactory.createToc( url.openStream() );
			
			File file = WebpubTestPlugin.createTempFile("TocStoreTest.testTocStoreTocOutputStoream");
			OutputStream out = new FileOutputStream(file);
			
			TocWriter.storeToc(toc, out);
			Toc newToc = TocFactory.createToc(new FileInputStream(file));
			
			Topic[] topics = toc.getAllTopics();
			Topic[] newTopics = toc.getAllTopics();
			
			assertEquals(topics.length, newTopics.length);
			assertEquals(
				topics[0].getSubtopics().length,
				newTopics[0].getSubtopics().length);

			assertEquals(
				topics[0].getSubtopics()[0].getHref(),
				newTopics[0].getSubtopics()[0].getHref() );
			
			assertTrue(toc.equals(newToc));
		}
	}
	
	void p(Object o) {
		System.out.println(getClass() + ":" + o);
	}

}
