# $Id: navigation_test.rb,v 1.1 2004/01/17 12:02:32 hn Exp $
# Copyright Narushima Hironori. All rights reserved.

require 'test/unit'
require 'sitemapper/navigation'

=begin

= NavigationTest

--- test_to_relative
		tests to_rel method. (That create relative path from two absolute path)
--- test_choose_next
		Choose next page object as a path form site map.
--- test_choose_prev
		Choose previous page object as a path form site map.
--- test_create_navi
		Test for create navigation object form includes url.
--- test_create_navi2
		Test for create navigation object.

=end

class NavigationTest < Test::Unit::TestCase

	def setup
		toc_file = File.join( File.dirname(__FILE__), 'toc.test.xml')
		
		@fac = SiteMapper::NavigatorFactory.instance(toc_file)
		@doc = @fac.doc
		
		assert_same( @fac, SiteMapper::NavigatorFactory.instance(toc_file))
	end

	def test_to_ro_rel
		current = '/dir_1/dir_2/dir_3/test.txt'
		
		other = '/dir_1/dir_2/dir_3/dir_4/dir_5/test.txt'
		assert_equal('dir_4/dir_5/test.txt', SiteMapper::to_rel(current, other) )
		
		other = '/dir_1/test.txt'
		assert_equal('../../test.txt', SiteMapper::to_rel(current, other) )
		
		other = '/dir_1/dir_6/dir_7/test.txt'
		assert_equal('../../dir_6/dir_7/test.txt', SiteMapper::to_rel(current, other) )
		
		other = '/dir_8/test.txt'
		assert_equal('../../../dir_8/test.txt', SiteMapper::to_rel(current, other) )
	end

	def test_choose_next
		# to children
		elem = @fac.search_element(@doc, 'test1/a.html')
		e = @fac.choose_next(elem)
		assert_equal('test2/b.html', e.attributes['href'])
		
		# to same level
		elem = @fac.search_element(@doc, 'test2/b.html')
		e = @fac.choose_next(elem)
		assert_equal('test2/c.html', e.attributes['href'])
		
		# to parent-next
		elem = @fac.search_element(@doc, 'test2/c.html')
		e = @fac.choose_next(elem)
		assert_equal('test3/a.html', e.attributes['href'])
		
		# two levels jump
		elem = @fac.search_element(@doc, 'test3/c.html')
		e = @fac.choose_next(elem)
		assert_equal('d.html', e.attributes['href'])
		
		# last
		elem = @fac.search_element(@doc, 'test4/c.html')
		assert_nil( @fac.choose_next(elem))
	end

	def test_choose_prev
		# to children
		elem = @fac.search_element(@doc, 'test1/a.html')
		e = @fac.choose_prev(elem)
		assert_equal('c.html', e.attributes['href'])
		
		# to same level
		elem = @fac.search_element(@doc, 'test2/c.html')
		e = @fac.choose_prev(elem)
		assert_equal('test2/b.html', e.attributes['href'])
		
		# to parent-next
		elem = @fac.search_element(@doc, 'test2/b.html')
		e = @fac.choose_prev(elem)
		assert_equal('test1/a.html', e.attributes['href'])
		
		# two levels jump
		elem = @fac.search_element(@doc, 'd.html')
		e = @fac.choose_prev(elem)
		assert_equal('test3/c.html', e.attributes['href'])
		
		# last
		elem = @fac.search_element(@doc, 'home.html')
		assert_nil( @fac.choose_prev(elem))
	end

	def test_create_navi
		ln = @fac.create_by_path('test3/c.html')
		assert_equal( '../home.html', ln[:start][:url] )

		assert_equal( '../a.html', ln[:chapter][:url] )
		assert_equal( 'A', ln[:chapter][:title] )

		assert_equal( 'a.html', ln[:section][:url] )
		assert_equal( '3A', ln[:section][:title] )

		assert_equal( 'c.html', ln[:subsection][:url] )
		assert_equal( '3C', ln[:subsection][:title] )

		assert_nil( ln[:subsubsection] )
		assert_nil( ln[:subsubsubsection] )

		assert_equal( 'a.html', ln[:up][:url] )
		assert_equal( '3A', ln[:up][:title] )

		assert_equal( '../d.html', ln[:next][:url] )
		assert_equal( 'D', ln[:next][:title] )

		assert_equal( 'a.html', ln[:prev][:url] )
		assert_equal( '3A', ln[:prev][:title] )
	end

end
