#
# $Id: console_result_distributer.rb,v 1.1 2004/06/02 00:42:35 hn Exp $
# Copyright Narushima Hironori. All rights reserved.
#

module Webpub

class ConsoleResultDistributer

	attr_reader :out

	def initialize(out = $stdout)
		@out = out
	end

	def successed(desc)
		@out << "<<<OK,#{desc.publish_from},#{desc.by},#{desc.publish_to},>>>\n"
	end

	def error(desc, ex)
		@out <<
			"<<<FAILED,#{desc.publish_from},#{desc.by},#{desc.publish_to},\n" +
			Webpub::to_fail_str(ex) +
			">>>\n"
	end

	def ConsoleResultDistributer::result_parser(lines)
		ok = []
		failed = []
		lines.each { |l|
			if /^<<<(.+?),(.+?),(.+?),(.+?),/ === l
				case $1
					when 'OK'
						ok << [$2, $3, $4]
					when 'FAILED'
						failed << [$2, $3, $4, []]
				end
			else
				failed.last[3] << l if failed.last and !(/^>>>$/ === l)
			end
		}
		
		[ok, failed]
	end

end

end