/*
 * $Id: PresetManager.java,v 1.10 2004/06/10 21:15:11 hn Exp $
 * Copyright Narushima Hironori. All rights reserved.
 */
package com.narucy.webpub.core.preset;

import java.net.URL;
import java.util.*;

import org.eclipse.core.runtime.*;
import org.osgi.framework.Bundle;

import com.narucy.webpub.core.WebpubPlugin;

/**
 * PresetManager provides to load extension point
 * "com.narucy.webpub.core.presets".
 */
public class PresetManager {
	
	final static String
		ID_PRESETS_EXTENSION = WebpubPlugin.ID_PLUGIN + ".presets";

	public static PresetManager instance = null;
	
	public static PresetManager getInstance() {
		if(instance == null){
			instance = new PresetManager();
		}
		return instance;
	}
	
	HashMap presets = new HashMap();

	private PresetManager(){
		// collect preset extensions
		IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(ID_PRESETS_EXTENSION);
		IExtension[] extensions = extensionPoint.getExtensions();
		
		for (int i = 0; i < extensions.length; i++) {
			IExtension ext = extensions[i];
			IConfigurationElement[] elems = ext.getConfigurationElements();
			for (int j = 0; j < elems.length; j++) {
				IConfigurationElement elem = elems[j];
				if( elem.getName().equals("preset") ){
					try {
						addPreset( createPreset(elem) );
					} catch (CoreException e) {
						WebpubPlugin.handleException(e);
					}
				}
			}
		}
	}
	
	/**
	 * Creates Preset instance as specify IConfigurationElement.
	 */
	static Preset createPreset(IConfigurationElement elem) throws CoreException {
		String presetRootPath = elem.getAttribute("path");
		Bundle bundle = Platform.getBundle(elem.getDeclaringExtension().getNamespace());
		URL presetRoot = bundle.getEntry(presetRootPath);
		if(presetRoot == null){
			throw new CoreException(new Status(
					IStatus.ERROR,
					WebpubPlugin.ID_PLUGIN,
					IStatus.OK,
					"specified resource is not exist: " + presetRootPath,
					null));
		}
		return createPreset(
				presetRoot,
				elem.getAttribute("name"),
				elem.getAttribute("description"));
		
	}

	public static Preset createPreset(URL baseDirectory, String name, String description) throws CoreException{
		String url = baseDirectory.toString();
		String ext = url.substring(url.length()-4);
		if( ext.equals(".zip") || ext.equals(".jar")){
			return new ZippedPreset(baseDirectory, name, description);
		} else {
			return new FilePreset(baseDirectory, name, description);
		}
	}
	
	public void addPreset(Preset preset){
		presets.put(preset.getName(), preset);
	}
	
	public String[] getPresetNames() {
		String[] names = (String[])presets.keySet().toArray(new String[presets.size()]);
		Arrays.sort(names);
		return names;
	}
	
	public Preset getPreset(String name){
		return (Preset)presets.get(name);
	}

	public Preset[] getPresets() {
		String[] names = getPresetNames();
		Preset[] ps = new Preset[names.length];
		for (int i = 0; i < names.length; i++) {
			ps[i] = (Preset)presets.get(names[i]);
		}
		return ps;
	}
}
