/*
 * $Id: ERBErrorHandler.java,v 1.7 2004/06/07 06:46:35 hn Exp $
 * Copyright Narushima Hironori. All rights reserved.
 */
package com.narucy.webpub.core.publish;

import java.util.regex.*;

import org.eclipse.core.resources.*;
import org.eclipse.core.runtime.CoreException;

import com.narucy.webpub.core.RubyException;

/**
 * 
 */
class ERBErrorHandler extends PublishErrorHandler {

	// syntax error analyze pattern
	// e.g, "(erb):11: syntax error"
	Pattern erbErrorPattern = Pattern.compile(".*\\(erb\\):(\\d+):(.+)");
	
	protected IMarker createMarker(IResource res, RubyException ex) throws CoreException {
		IMarker marker = super.createMarker(res, ex);

		IMarker scriptMarker = super.createMarkerAsScript(res.getProject(), ex);
		if(scriptMarker != null){
			marker.setAttribute(PublisherBuilder.ATTR_RELATE_RESOURCE, scriptMarker.getResource().getFullPath().toString());
			return marker;
		}
		
		// not found script file in stack trace
		scriptMarker = getMarker(res, PublisherBuilder.MARKER_RUBY);
		scriptMarker.setAttribute(IMarker.SEVERITY, IMarker.SEVERITY_ERROR);
		scriptMarker.setAttribute(IMarker.MESSAGE, ex.getMessage());
		scriptMarker.setAttribute(PublisherBuilder.ATTR_BACKTRACE, ex.toStackTraceString());
		
		// handle erb inside only probrem
		RubyException.TraceItem[] traces = ex.getTraceItems();
		for (int i=0; i<traces.length; i++) {
			RubyException.TraceItem t = traces[i];
			if("(erb)".equals(t.script)){
				scriptMarker.setAttribute(IMarker.LINE_NUMBER, t.lineNumber);
				return marker;
			}
		}
		
		// handle parse error
		if(scriptMarker.getAttribute(IMarker.LINE_NUMBER, -1) == -1){
			Matcher m = erbErrorPattern.matcher(ex.getMessage());
			if(m.matches()){
				scriptMarker.setAttribute(IMarker.LINE_NUMBER, Integer.parseInt(m.group(1)));
				scriptMarker.setAttribute(IMarker.MESSAGE, m.group(2).trim());
			}
		}
		
		return marker;
	}

}
