/*
 * $Id: PublishDescription.java,v 1.8 2004/06/07 06:46:35 hn Exp $
 * Copyright Narushima Hironori. All rights reserved.
 */
package com.narucy.webpub.core.publish;

import java.util.*;

import org.eclipse.core.runtime.IPath;

import com.narucy.webpub.core.Wildcard;

public class PublishDescription {

	final String publishBy;
	IPath publishTo = null;
	TreeMap arguments = new TreeMap();

	public PublishDescription(String publishBy) {
		if(publishBy == null){
			throw new IllegalArgumentException("constructor must be specify string");
		}
		this.publishBy = publishBy;
	}

	public String getPublishBy() {
		return publishBy;
	}

	public void setPublishTo(IPath to) {
		to = to.makeAbsolute();
		if(Wildcard.containWildcardSymble(to)){
			to = new Wildcard(to);
		}
		publishTo = to;
	}

	public String[] getArgumentKeys(){
		return (String[])arguments.keySet().toArray(new String[arguments.size()]);
	}

	/**
	 * Returns publish location.
	 */
	public IPath getPublishTo() {
		return publishTo;
	}

	/**
	 * Sets argument for publish. if value specify null, remove this argument entry.
	 */
	public void setArgument(String key, String value){
		if( value == null){
			arguments.remove(key);
		}else{
			arguments.put(key, value);
		}
	}
	
	/**
	 * Returns argument key/values each keys and values type is a String.
	 */
	public Map getArguments(){
		return (Map)arguments.clone();
	}
	
	/**
	 * Returns argument for publish.
	 */
	public String getArgument(String key){
		return (String)arguments.get(key);
	}
	
	public boolean equals(Object obj) {
		if( !(obj instanceof PublishDescription)){
			return false;
		}
		PublishDescription other = (PublishDescription)obj;
		
		return
			argumentsEquals(other) &&
			publishTo != null ?
				publishTo.equals( other.publishTo) :
				null == other.publishTo;
	}

	/**
	 * Return true if publish content (Publishing tool id, and that argument
	 * without publish location differer).
	 */
	public boolean argumentsEquals(PublishDescription other){
		return
			publishBy.equals(other.publishBy) &&
			arguments.equals(other.arguments);
	}
	
	public String toString() {
		return "by=" + publishBy + ",publish_to=" + publishTo + ",arguments=" + arguments;
	}
	
}
