/*
 * $Id: PublishMappingStore.java,v 1.5 2004/06/07 06:46:35 hn Exp $
 * Copyright Narushima Hironori. All rights reserved.
 */
package com.narucy.webpub.core.publish;

import java.io.*;
import java.util.*;

import javax.xml.parsers.*;

import org.eclipse.core.resources.*;
import org.eclipse.core.runtime.CoreException;
import org.w3c.dom.*;
import org.xml.sax.SAXException;

import com.narucy.webpub.core.WebpubPlugin;

public class PublishMappingStore {

	DocumentBuilderFactory docBuilderFac = DocumentBuilderFactory.newInstance();
	
	static PublishMappingStore instance = null;
	
	public static PublishMappingStore getInstance(){
		if(instance == null){
			instance = new PublishMappingStore();
		}
		return instance;
	}

	HashMap mappingsCache = new HashMap();

	private PublishMappingStore(){
		ResourcesPlugin.getWorkspace().addResourceChangeListener(new IResourceChangeListener() {
			IResourceDeltaVisitor visitor = new IResourceDeltaVisitor() {
				public boolean visit(IResourceDelta delta) throws CoreException {
					if(delta.getKind() == IResourceDelta.CHANGED || delta.getKind() == IResourceDelta.REMOVED){
						mappingsCache.remove(delta.getResource());
					}
					return true;
				}
			};
			
			public void resourceChanged(IResourceChangeEvent event) {
				if(event.getDelta() != null){
					try {
						event.getDelta().accept(visitor);
					} catch (CoreException e) {
						WebpubPlugin.handleException(e);
					}
				}
			}
		});
	}
	
	public PublishMapping[] getMapping(IFile propFile) {
		PublishMapping[] mappings = null;
		if(mappingsCache.containsKey(propFile)){
			mappings = (PublishMapping[])mappingsCache.get(propFile);
		}else{
			try {
				mappings = createMapping(propFile);
			} catch (IllegalConfigurationException e) {
			}
			mappingsCache.put(propFile, mappings);
		}
		return (PublishMapping[])mappings.clone();
	}
	
	PublishMapping[] createMapping(IFile propFile) throws IllegalConfigurationException {
		PublishMapping[] mappings = null;
		
		InputStream stream = null;
		Exception error = null;
		try {
			stream = propFile.getContents();
			Document doc = docBuilderFac.newDocumentBuilder().parse(stream);
			Element rootElem = doc.getDocumentElement();
			NodeList mappingNodes = rootElem.getElementsByTagName("mapping");
			
			mappings = new PublishMapping[mappingNodes.getLength()];
			for(int i=0; i<mappings.length; i++){
				Element elem = (Element)mappingNodes.item(i);
				NamedNodeMap entry = elem.getElementsByTagName("publish").item(0).getAttributes();
				Map m = new HashMap();
				for(int j=0; j<entry.getLength(); j++){
					Node n = entry.item(j);
					m.put(n.getNodeName(), n.getNodeValue());
				}
				m.put("pattern", elem.getAttribute("pattern"));
				mappings[i] = new PublishMapping(propFile, m);
			}
		} catch (SAXException e) {
			error = e;
		} catch (IOException e) {
			error = e;
		} catch (ParserConfigurationException e) {
			error = e;
		} catch(CoreException e){
			error = e;
		} finally{
			if(stream != null){
				try {
					stream.close();
				} catch (IOException e) {
					error = e;
				}
			}
			if( error != null){
				throw new IllegalConfigurationException(error);
			}
		}
		
		return mappings;
	}

}