/*
 * $Id: PublishMappingWriter.java,v 1.4 2004/06/07 06:46:35 hn Exp $
 * Copyright Narushima Hironori. All rights reserved.
 */
package com.narucy.webpub.core.publish;

import java.io.*;

import org.w3c.dom.*;

import com.narucy.webpub.core.WebpubPlugin;

/**
 * 
 */
public class PublishMappingWriter {

	private PublishMappingWriter() {
	}
	
	public static void store(File file, Document doc){
		FileOutputStream out = null;
		try {
			out = new FileOutputStream(file);
			writeMapping(new PrintStream(out), doc);
		} catch (FileNotFoundException e) {
			WebpubPlugin.handleException(e);
		} finally{
			if( out != null) {
				try {
					out.close();
				} catch (IOException e1) {
					WebpubPlugin.handleException(e1);
				}
			}
		}
	}

	public static void writeMapping(PrintStream out, Document doc){
		out.println("<?xml version=\"1.0\"?>");
		out.println("<publishMappings>");
		
		NodeList nodeList = doc.getDocumentElement().getElementsByTagName("mapping");
		for(int i=0; i<nodeList.getLength(); i++){
			Element mappingElem = (Element)nodeList.item(i);
			out.println("\t<mapping pattern=\"" +  mappingElem.getAttribute("pattern") + "\">");
			
			Element publishElem = (Element)mappingElem.getElementsByTagName("publish").item(0);
			out.print("\t\t<publish");
			
			NamedNodeMap map = publishElem.getAttributes();
			for(int j=0; j<map.getLength(); j++){
				Node n = map.item(j);
				String v = n.getNodeValue();
				if(v.length() > 0){
					out.print(" " + n.getNodeName() + "=\"" + v + "\"");
				}
			}
			out.println(" />");
			out.println("\t</mapping>");
		}
		out.println("</publishMappings>");
	}

}

