/*
 * $Id: TemplateSynchronizeBuilder.java,v 1.9 2004/06/07 06:46:38 hn Exp $
 * Copyright Narushima Hironori. All rights reserved.
 */
package com.narucy.webpub.core.template;

import java.util.*;

import org.eclipse.core.resources.*;
import org.eclipse.core.runtime.*;

import com.narucy.webpub.core.*;

/**
 * TemplateSynchronizeBuilder.
 */
public class TemplateSynchronizeBuilder extends IncrementalProjectBuilder {
	
	final public static String
		ID_BUILDER = WebpubPlugin.ID_PLUGIN + ".templateSynchronizeBuilder";
	
	protected IProject[] build(int kind, Map args, IProgressMonitor monitor) throws CoreException {
		monitor.beginTask("Begin Template", 3);
		
		try {
			IProject proj = getProject();
			IResourceDelta delta = getDelta(proj);
			if(delta == null){
				return null;
			}
			final WebProject webProj = (WebProject)proj.getNature(WebProject.ID_NATURE);
			final ArrayList
				added = new ArrayList(),
				removed = new ArrayList();
			
			delta.accept( new IResourceDeltaVisitor() {
				public boolean visit(IResourceDelta d) throws CoreException {
					IResource res = d.getResource();
					if(res instanceof IFile){
						if(webProj.getTemplateManager().isTemplateFile((IFile)res) ){
							int kind = d.getKind();
							if(kind == IResourceDelta.REMOVED){
								removed.add(res);
							}else if(kind == IResourceDelta.ADDED || kind == IResourceDelta.CHANGED){
								added.add(res);
							}
						}
					}
					return true;
				}
			});
			monitor.worked(1);
			
			TemplateManager tmplManager = ((WebProject)proj.getProject().getNature(WebProject.ID_NATURE)).getTemplateManager();
			tmplManager.syncronizeTemplate(
				(IFile[])added.toArray(new IFile[added.size()]),
				(IFile[])removed.toArray(new IFile[removed.size()]),
				new SubProgressMonitor(monitor, 2));
			
			return null;
		}finally{
			monitor.done();
		}
	}

}
