/*
 * $Id: WebpubUIPluginTest.java,v 1.2 2004/06/10 21:15:12 hn Exp $
 * Copyright Narushima Hironori. All rights reserved.
 */
package com.narucy.webpub.ui.tests;

import junit.framework.TestCase;

import org.eclipse.core.runtime.*;
import org.eclipse.jface.preference.IPreferenceStore;

import com.narucy.webpub.core.WebpubPlugin;
import com.narucy.webpub.ui.WebpubUIPlugin;

public class WebpubUIPluginTest extends TestCase {

	public void testInterpreterLocationChanged() {
		WebpubPlugin corePlugin = WebpubPlugin.getDefault();
		IPreferenceStore store = WebpubUIPlugin.getDefault().getPreferenceStore();
		
		IPath before = corePlugin.getRubyCommandPath();
		try{
			assertEquals(before.toString(), store.getString(WebpubUIPlugin.RUBY_INTERPRETER_LOCATION));
			
			IPath after = new Path("/foo/bar");
			// initial value check for testing.
			assertTrue(!before.equals(after));
			store.setValue(WebpubUIPlugin.RUBY_INTERPRETER_LOCATION, after.toString());
			
			assertEquals(after.toString(), store.getString(WebpubUIPlugin.RUBY_INTERPRETER_LOCATION));
			assertEquals(after, corePlugin.getRubyCommandPath());
		}finally{
			corePlugin.setRubyCommandPath(before);
		}
	}

}
