/*
 * $Id: TableElementModelTest.java,v 1.1 2004/04/11 08:39:54 hn Exp $
 * Copyright Narushima Hironori. All rights reserved.
 */
package com.narucy.webpub.ui.tests.editors.html.wizards;

import junit.framework.TestCase;

import org.w3c.dom.Element;

import com.narucy.webpub.ui.editors.html.wizards.TableElementModel;

/**
 * 
 */
public class TableElementModelTest extends TestCase {

	public TableElementModelTest(String arg0) {
		super(arg0);
	}

	/*
	 * a b c
	 * d e f 
	 * g h i
	 * 
	 * j k l
	 * m n o
	 * p q r
	 * s t u
	 */
	public void testDown() throws Exception {
		TableElementModel model = new TableElementModel(
			"a a a\nb b b\nc c c\nd d d\ne e e\nf f f\ng g g", true);
		
		Element[] rows = model.getRows();
		assertEquals( rows.length, 7);
		
		// down test
		model.move(rows[0], 3);
		Element[] newRows = model.getRows();
		assertEquals( rows[0], newRows[3]);
		rows = newRows;
		
		// down test
		model.move(rows[3], 1);
		newRows = model.getRows();
		assertEquals( rows[3], newRows[4]);
		rows = newRows;
		
		model.move(rows[4], 100);
		newRows = model.getRows();
		assertEquals( rows[4], newRows[6]);
	}

	public void testUp() throws Exception {
		TableElementModel model = new TableElementModel(
			"a a a\nb b b\nc c c\nd d d\ne e e\nf f f\ng g g", true);
		
		Element[] rows = model.getRows();
		
		// down test
		model.move(rows[6], -3);
		
		Element[] newRows = model.getRows();
		for (int i = 0; i < newRows.length; i++) {
			Element element = newRows[i];
		}
		assertEquals( rows[6], newRows[3]);
		rows = newRows;
		
		// down test
		model.move(rows[3], -1);
		newRows = model.getRows();
		assertEquals( rows[3], newRows[2]);
		rows = newRows;
		
		model.move(rows[2], -100);
		newRows = model.getRows();
		assertEquals( rows[2], newRows[0]);
	}
	
	public void removeColumns() throws Exception {
		TableElementModel model = new TableElementModel("a b c d\ne f g h\ni j k l", true);
		model.setColumnCount(5);
		
		Element[] rows = model.getRows();
		for (int i = 0; i < rows.length; i++) {
			assertEquals(5, TableElementModel.chooseCellElements( rows[i]).length );
		}
		
		model.setColumnCount(2);
		rows = model.getRows();
		for (int i = 0; i < rows.length; i++) {
			assertEquals(2, TableElementModel.chooseCellElements( rows[i]).length );
		}
	}

	public void testExpandCodes() throws Exception {
		String code = "<table>\n<tr><td>a</td><td>b</td><td>c</td></tr>\n<tr><td>a</td><td>b</td><td>c</td></tr>\n</table>\n";
		TableElementModel model = new TableElementModel(code, false);
		assertEquals( code, model.expandCodes() );
	}
	
	public void testToColumnName(){
		assertEquals("A", TableElementModel.toColumnName(0));
		assertEquals("Z", TableElementModel.toColumnName(25));
		assertEquals("AA", TableElementModel.toColumnName(26));
		assertEquals("AZ", TableElementModel.toColumnName(51));
		assertEquals("BA", TableElementModel.toColumnName(52));
	}
	
	public void testToNumeric(){
		assertEquals(0, TableElementModel.toNumeric("A"));
		assertEquals(25, TableElementModel.toNumeric("Z"));
		assertEquals(26, TableElementModel.toNumeric("AA"));
		assertEquals(51, TableElementModel.toNumeric("AZ"));
		assertEquals(52, TableElementModel.toNumeric("BA"));

		assertEquals(-1, TableElementModel.toNumeric("..."));
	}
	
}
