/*
 * $Id: TocControllerTest.java,v 1.4 2004/06/07 06:46:44 hn Exp $
 * Copyright Narushima Hironori. All rights reserved.
 */
package com.narucy.webpub.ui.tests.editors.toc;

import junit.framework.TestCase;

import org.eclipse.core.resources.*;
import org.eclipse.core.runtime.CoreException;

import com.narucy.webpub.core.WebProject;
import com.narucy.webpub.core.tests.WebpubTestPlugin;
import com.narucy.webpub.ui.editors.toc.TocController;

/**
 * 
 */
public class TocControllerTest extends TestCase {

	WebProject webProj;

	public TocControllerTest(String name) {
		super(name);
	}

	protected void setUp() throws Exception {
		webProj = WebpubTestPlugin.createTestProject("test_projects/SitemapTest");
	}

	public void testChooseTitle() throws CoreException {
		IContainer folder = webProj.getFolder(WebProject.PUBLISH_FOLDER);
		IProject proj = webProj.getProject();
		
		TocController controller = new TocController(
				folder,
				webProj.getToc(proj.getFile("toc.xml") ));
		
		assertFalse( controller.isAllResourcesAdded() );
	}

	protected void tearDown() throws Exception {
		WebpubTestPlugin.forceDelete(webProj.getProject());
	}

}
