/*
 * $Id: WebProjectStructureBlockTest.java,v 1.7 2004/06/07 06:46:43 hn Exp $
 * Copyright Narushima Hironori. All rights reserved.
 */
package com.narucy.webpub.ui.tests.properties;

import java.util.Stack;

import junit.framework.TestCase;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.swt.widgets.*;

import com.narucy.webpub.core.*;
import com.narucy.webpub.core.tests.WebpubTestPlugin;
import com.narucy.webpub.ui.properties.WebProjectStructureBlock;

/**
 * <ul>
 * <li>source folder or script folder must oneself web project underly folder,
 * display error message in other case.
 * <ul>publish folder arrowed any container, but only ht source same folder is not arrowed.
 * </ul>
 */
public class WebProjectStructureBlockTest extends TestCase {
	
	public void testNoWebProjectInput() throws Exception {
		final Stack statuses = new Stack();
		WebProjectStructureBlock block = new WebProjectStructureBlock(new IStatusChangeListener() {
			public void statusChanged(IStatus s) {
				statuses.push(s);
			}
		});
		
		Shell sh = new Shell();
		try{
			block.createControl(sh, null);
			block.setFolderData("a", "b", "c");
			
			IStatus s = (IStatus)statuses.pop();
			assertEquals(IStatus.OK, s.getSeverity());
		}finally{
			sh.dispose();
		}
	}

	public void testValidate() throws Exception {
		final Stack statuses = new Stack();
		WebProjectStructureBlock block = new WebProjectStructureBlock(new IStatusChangeListener() {
			public void statusChanged(IStatus s) {
				statuses.push(s);
			}
		});
		
		WebProject wp = WebpubTestPlugin.createTestProject("test_projects/TemplateTest-UTF-8");
		Shell sh = new Shell();
		try{
			// tests initial input
			block.createControl(sh, wp.getProject());
			block.setFolderData("src", "rbs", "pub");
			assertEquals(1, statuses.size());
			IStatus s = (IStatus)statuses.pop();
			assertEquals(IStatus.OK, s.getSeverity());
			
			// test initial illegal input.
			block.setFolderData("", "rbs", "pub");
			assertEquals(1, statuses.size());
			s = (IStatus)statuses.pop();
			assertEquals(IStatus.ERROR, s.getSeverity());
			assertEquals("Soruce folder path is empty", s.getMessage());
			
			// folder name input change form text control
			block.getTextControl(WebProject.HTSOURCES_FOLDER).setText("src");
			Text input = block.getTextControl(WebProject.PUBLISH_FOLDER);
			input.setText("");
			
			// nodify modify event count are two.
			assertEquals(2, statuses.size());
			s = (IStatus)statuses.pop();
			assertEquals(IStatus.ERROR, s.getSeverity());
			assertEquals("Publish folder path is empty", s.getMessage());
			
			s = (IStatus)statuses.pop();
			assertEquals(IStatus.OK, s.getSeverity());
			
			// UITestUtils.displayShell(sh);
		}finally{
			sh.dispose();
			WebpubTestPlugin.forceDelete(wp.getProject());
		}
	}
	
}
