/*
 * $Id: HTPreviewLinkWithEditorManagerTest.java,v 1.13 2004/06/07 06:46:43 hn Exp $
 * Copyright Narushima Hironori. All rights reserved.
 */
package com.narucy.webpub.ui.tests.views;

import java.util.Arrays;

import junit.framework.TestCase;

import org.eclipse.core.resources.*;
import org.eclipse.core.runtime.*;
import org.eclipse.jface.action.Action;
import org.eclipse.ui.*;
import org.eclipse.ui.part.FileEditorInput;

import com.narucy.webpub.core.WebProject;
import com.narucy.webpub.core.tests.WebpubTestPlugin;
import com.narucy.webpub.ui.WebpubUIPlugin;
import com.narucy.webpub.ui.tests.UITestUtils;
import com.narucy.webpub.ui.views.*;

/**
 * <ul>
 * <li>Workbench's preference specified HTML preview target file is opened when
 * HTML preview regist preview file action in pull down menu.
 * <li>HTML preview pull down menu registed file is closed when unregist that
 * action.
 * <li>Link with editor icon pressed when preview show current open editor file
 * content. 
 * </ul>
 */
public class HTPreviewLinkWithEditorManagerTest extends TestCase {

	IWorkbenchPage page;
	HTPreView preview;
	
	public HTPreviewLinkWithEditorManagerTest(String name) {
		super(name);
	}

	public void testGetRegistedFiles() throws Exception {
		WebProject webProject = WebpubTestPlugin.createTestProject("test_projects/TemplateTest-EUC-JP");
		IProject proj = webProject.getProject();
		try{
			Preferences pref = ResourcesPlugin.getPlugin().getPluginPreferences();
			pref.setValue(ResourcesPlugin.PREF_ENCODING, webProject.getString(WebProject.ENCODING));
			
			page = WebpubUIPlugin.getActivePage();
			
			preview = (HTPreView)page.showView("com.narucy.webpub.ui.views.HTPreView");
			HTPreviewLinkWithEditorManager mgr = preview.getLinkWithEditorManager();
			Action linkAct = mgr.getLinkWithEditorAction();
			linkAct.setChecked(false);
			
			IFile
				af = proj.getFile("ht_sources/a.html"),
				bf = proj.getFile("ht_sources/b.htm"),
				cf = proj.getFile("ht_sources/c.erb"),
				df = proj.getFile("ht_sources/x.xhtml");
			
			IEditorPart ae = openEditor(af);
			IEditorPart be = openEditor(bf);
			IEditorPart ce = openEditor(cf);
			IEditorPart de = openEditor(df);
			
			// regist menu item test
			// (not preview file htat x.xhtml is rejected)
			HTPreViewTest.assertRegistedFiles(preview, new IFile[]{af, bf, cf});
			
			// preview action change
			mgr.getBrowseAction(af).run();
			assertBrowsePublishFrom(af);
			
			mgr.getBrowseAction(bf).run();
			assertBrowsePublishFrom(bf);
			
			mgr.getBrowseAction(cf).run();
			assertBrowsePublishFrom(cf);
			
			// unregist action
			page.closeEditor(ae, false);
			page.closeEditor(be, false);
			assertTrue(Arrays.equals(new IFile[]{cf}, mgr.getRegistedFiles()));
			
			// link with editor action state changed
			be = openEditor(bf);
			ae = openEditor(af);
			
			mgr.getBrowseAction(bf).run();
			assertBrowsePublishFrom(bf);
			
			assertEquals(af, ((IFileEditorInput)page.getActiveEditor().getEditorInput()).getFile());
			
			linkAct.setChecked(true);
			linkAct.run();
			
			assertBrowsePublishFrom(af);
			
			// active editor changed
			openEditor(bf);
			assertBrowsePublishFrom(bf);
			
			IPath toPath = webProject.getPublishDescriptionFactory().create(af).getPublishTo();
			preview.browse( webProject.getFolder(WebProject.PUBLISH_FOLDER).getFile(toPath).getLocation().toFile().toURL().toString() );
			assertBrowsePublishFrom(af);
			
			assertEquals(af, ((IFileEditorInput) preview.getSite().getPage().getActiveEditor().getEditorInput()).getFile());
			
			linkAct.setChecked(false);
			linkAct.run();
		
			openEditor(cf);
			assertBrowsePublishFrom(af);
		}finally{
			page.closeAllEditors(false);
			page.hideView(preview);
			WebpubTestPlugin.forceDelete(proj);
		}
	}
	
	void assertBrowsePublishFrom(IFile f) throws Exception {
		do{
			Thread.sleep(1000);
			UITestUtils.whileReadAndDispatch();
		}while(preview.isLoading());
		assertEquals(f, preview.getCurrentPublishFrom());
	}
	
	IEditorPart openEditor(IFile f) throws Exception{
		return page.openEditor(new FileEditorInput(f), "org.eclipse.ui.DefaultTextEditor");
	}


}
