/*
 * $Id: DocLineIterator.java,v 1.3 2004/06/07 06:46:18 hn Exp $
 * Copyright Narushima Hironori. All rights reserved.
 */
package com.narucy.webpub.ui;

import java.util.Iterator;

import org.eclipse.jface.text.*;

public class DocLineIterator implements Iterator {
		
	int lineIndex = 0;
	IDocument doc;
		
	public DocLineIterator(IDocument doc){
		this.doc = doc;
	}
				
	public boolean hasNext() {
		return lineIndex < doc.getNumberOfLines();
	}

	public Object next() {
		try{
			IRegion region = doc.getLineInformation(lineIndex);
			String line = doc.get(region.getOffset(), region.getLength());
			return line;
		} catch (BadLocationException e) {
			WebpubUIPlugin.handleException(e);
			return null;
		}finally{
			lineIndex++;
		}
	}

	public void remove() {}
}