/*
 * $Id: HTParser.java,v 1.4 2004/06/07 06:46:18 hn Exp $
 * Copyright Narushima Hironori. All rights reserved.
 */
package com.narucy.webpub.ui;

import java.util.Arrays;

import org.eclipse.jface.text.*;

/**
 * 
 */
public class HTParser {
	
	static char[] tagNameEndChars = {'>', ' ', '\n', '\r', '\t'};
	static {
		Arrays.sort(tagNameEndChars);
	}

	private HTParser() {
	}
	
	public static boolean isInToken(IDocument doc, int currentOffset) throws BadLocationException {
		for(int i=currentOffset-1; i>=0; i--){
			char c = doc.getChar(i);
			if(c == '<' && doc.getChar(i+1) != '!'){
				return true;
			}else if(c == '>' && doc.getChar(--i) != '-'){
				return false;
			}
		}
		return false;
	}
	
	public static ITextSelection getElementRange(IDocument doc, int currentOffset) throws BadLocationException {
		return getElementRange(doc, currentOffset, 0);
	}
	
	public static ITextSelection getElementRange(IDocument doc, int offset, int outRange) throws BadLocationException {
		// cursor move to out side if out rang values is over 0.
		for(int count = 0; count<outRange && offset>=0; offset--){
			if(doc.getChar(offset) == '<' && doc.getChar(offset+1) != '!'){
				count++;
			}
		}
		
		int begin = -1, end = -1, flag = 0;
		boolean inToken = false, inEnd = false;
		
		for(int i=offset; i>=0; i--){
			char c = doc.getChar(i);
			if(c == '>' && doc.getChar(i-1) != '-' && i != offset){
				if( doc.getChar(--i) == '/'){
					while(i > 0 && doc.getChar(--i) != '<' && doc.getChar(i+1) != '!');
				}else{
					inToken = true;
				}
			} else if (inToken){
				if (c == '/' && doc.getChar(--i) == '<'){
					inToken = false;
					flag++;
				} else if (c == '<' && doc.getChar(i+1) != '!'){
					inToken = false;
					if( flag > 0){
						flag--;
					}else{
						begin = i;
						break;
					}
				}
			} else if (c == '<' && doc.getChar(i+1) != '!' && doc.getChar(i+1) != '/'){
				begin = i;
				break;
			}
		}
		
		inToken = false;
		
		// empty element (</p> or <br />)
		for(int i=begin, len = doc.getLength(); i<len; i++){
			char c = doc.getChar(i);
			if( !inToken &&  c == '<' && doc.getChar(i+1) != '!'){
				inToken = true;
				if( doc.getChar(++i) == '/'){
					inEnd = true;
				}
			}else if (c == '/' && doc.getChar(++i) == '>'){
				inToken = false;
				if( flag == 0){
					end = i+1;
					break;
				}
			}else if( c == '>' && doc.getChar(i-1) != '-'){
				if(inEnd){
					flag--;
					if(flag == 0){
						end = i+1;
						break;
					}
					inEnd = false;
				}else{
					flag++;
				}
				inToken = false;
			}
		}
		return new TextSelection(doc, begin, end-begin);
	}
	
	public static String getElementName(IDocument doc, int offset) throws BadLocationException {
		return chooseElementName(doc, offset, 0);
	}

	public static String chooseElementName(IDocument doc, int offset, int outRange) throws BadLocationException {
		return chooseElementName( getElementRange(doc, offset, outRange).getText());
	}

	public static String chooseElementName(String line){
		if( line == null){
			return null;
		}
		boolean flag = false;
		int b = 0, e = 0;
		for(int i=0, len = line.length(); i<len; i++){
			char c = line.charAt(i);
			if(c == '<'){
				flag = true;
				b = i + 1;
			}else if( flag && Arrays.binarySearch(tagNameEndChars, c) >= 0){
				e = i;
				break;
			}
		}
		return line.substring(b, e);
	}


}
