/*
 * $Id: WebpubPerspectiveFactory.java,v 1.4 2004/06/07 06:46:18 hn Exp $
 * Copyright Narushima Hironori. All rights reserved.
 */
package com.narucy.webpub.ui;

import org.eclipse.debug.ui.IDebugUIConstants;
import org.eclipse.ui.*;

public class WebpubPerspectiveFactory implements IPerspectiveFactory {

	public void createInitialLayout(IPageLayout layout) {
		String editorArea = layout.getEditorArea();

		// Top left: Resource Navigator view and Bookmarks view placeholder
		IFolderLayout topLeft =
			layout.createFolder("topLeft", IPageLayout.TOP, 0.25f, editorArea);
		topLeft.addView(IPageLayout.ID_RES_NAV);
		topLeft.addView("com.narucy.webpub.ui.views.TocView");
		
		IFolderLayout topCenter = layout.createFolder("topCenter", IPageLayout.RIGHT, 0.33f, "topLeft");
		topCenter.addView(IPageLayout.ID_OUTLINE);
		topCenter.addPlaceholder(IPageLayout.ID_BOOKMARKS);
		topCenter.addView(IPageLayout.ID_PROP_SHEET);
		topCenter.addView("com.narucy.webpub.ui.views.PublishConsoleView");

		IFolderLayout topRight =
			layout.createFolder("topRight",IPageLayout.RIGHT, 0.5f,"topCenter");
		topRight.addView(IPageLayout.ID_PROBLEM_VIEW);
		topRight.addView(IPageLayout.ID_TASK_LIST);
	
		// Bottom right: Task List view
		IFolderLayout right =
			layout.createFolder("right", IPageLayout.RIGHT, 0.6f, editorArea);
		right.addView("com.narucy.webpub.ui.views.HTPreView");
		right.addView("com.narucy.webpub.ui.views.GlobalTemplateView");
		
		// sets to open view shortcut
		layout.addShowViewShortcut(IPageLayout.ID_OUTLINE);
		layout.addShowViewShortcut(IPageLayout.ID_RES_NAV);
		layout.addShowViewShortcut("com.narucy.webpub.ui.views.SitemapView");
		layout.addShowViewShortcut("com.narucy.webpub.ui.views.GlobalTemplateView");
		layout.addShowViewShortcut("com.narucy.webpub.ui.views.HTPreView");
		layout.addShowViewShortcut("com.narucy.webpub.ui.views.PublishConsoleView");
		
		// sets new wizard shortcut.
		layout.addNewWizardShortcut("com.narucy.webpub.ui.wizards.NewWebProjectWizard");
		layout.addNewWizardShortcut("com.narucy.webpub.ui.wizards.NewWebPageWizard");
		layout.addNewWizardShortcut("org.eclipse.ui.wizards.new.folder");
		layout.addNewWizardShortcut("org.eclipse.ui.wizards.new.file");
		
		// sets action sets
		layout.addActionSet(IDebugUIConstants.LAUNCH_ACTION_SET);
	}

}
