/*
 * $Id: ModifyElementAction.java,v 1.3 2004/06/07 06:46:21 hn Exp $
 * Copyright Narushima Hironori. All rights reserved.
 */
package com.narucy.webpub.ui.actions;

import org.eclipse.core.runtime.*;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.text.*;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.SWT;
import org.eclipse.ui.*;
import org.eclipse.ui.texteditor.ITextEditor;

import com.narucy.webpub.ui.*;
import com.narucy.webpub.ui.editors.html.wizards.EditElementWizard;

/**
 * InsertTagAction
 */
public class ModifyElementAction implements IEditorActionDelegate {

	ITextEditor editor = null;
	
	public ModifyElementAction() {
	}
	
	public void setActiveEditor(IAction action, IEditorPart targetEditor) {
		if( targetEditor instanceof ITextEditor ){
			editor = (ITextEditor)targetEditor;
		}
	}

	public void run(IAction action) {
		try{
			IDocument doc =  editor.getDocumentProvider().getDocument(editor.getEditorInput());
			ITextSelection sel = HTParser.getElementRange(doc, ((ITextSelection)editor.getSelectionProvider().getSelection()).getOffset() );
			editor.getSelectionProvider().setSelection(sel);
			
			String text = sel.getText();
			if( text == null){
				throw new BadLocationException("Invalid text selection, can't choose element.");
			}
			String elemName = HTParser.chooseElementName(text);
			
			WizardDialog wizDialog =
				new WizardDialog(
					editor.getSite().getShell(),
					new EditElementWizard(editor, elemName) ){
			
				protected int getShellStyle() {
					return super.getShellStyle() | SWT.RESIZE;
				}
			};
			
			wizDialog.open();
		} catch(BadLocationException e){
			ErrorDialog dialog = new ErrorDialog(
				editor.getSite().getShell(),
				"Text Selection Error",
				"Invalid element hierarchy?",
				new Status(IStatus.WARNING, WebpubUIPlugin.ID_PLUGIN, IStatus.OK, e.getLocalizedMessage(), e),
				IStatus.WARNING);
			dialog.open();
		}
	}

	public void selectionChanged(IAction action, ISelection selection) {
	}

}
