/*
 * $Id: RepublishAllAction.java,v 1.6 2004/06/07 06:46:21 hn Exp $
 * Copyright Narushima Hironori. All rights reserved.
 */
package com.narucy.webpub.ui.actions;

import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.*;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;

import com.narucy.webpub.core.WebProject;

/**
 * 
 */
public class RepublishAllAction extends RepublishAction {

	public void run(IProgressMonitor monitor) throws CoreException {
		try{
			WebProject[] webProjects = WebProject.getWebProjects();
			monitor.beginTask("republish all project", webProjects.length);
			for (int i = 0; i < webProjects.length; i++) {
				webProjects[i].getProject().build(IncrementalProjectBuilder.FULL_BUILD, new SubProgressMonitor(monitor, 1, SubProgressMonitor.SUPPRESS_SUBTASK_LABEL));
			}
		}finally{
			monitor.done();
		}
	}
	
	public void selectionChanged(IAction action, ISelection selection) {
		// override for always enable
	}

}