/*
 * $Id: HTEditorActionContributor.java,v 1.5 2004/06/07 06:46:18 hn Exp $
 * Copyright Narushima Hironori. All rights reserved.
 */
package com.narucy.webpub.ui.editors.html;

import java.util.ArrayList;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.*;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.*;
import org.eclipse.ui.*;
import org.eclipse.ui.editors.text.TextEditorActionContributor;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.texteditor.ITextEditor;

import com.narucy.webpub.ui.WebpubUIPlugin;

/**
 * 
 */
public class HTEditorActionContributor extends TextEditorActionContributor {

	final static String
		M_ID_RELLINK = "com.narucy.webpub.ui.hteditor.rellink",
		M_PREFERENCE = "com.narucy.webpub.ui.hteditor.preference";

	IPreferenceStore pref = WebpubUIPlugin.getDefault().getPreferenceStore();

	IPropertyChangeListener prefListener = new IPropertyChangeListener() {
		public void propertyChange(PropertyChangeEvent event) {
			refreshActionStatus();
		}
	};

	ArrayList linkFactories = new ArrayList();
	ITextEditor activeEditor = null;
	IMenuManager linkMenu = null;
	IAction wordWrapAction = null;

	public HTEditorActionContributor() {
		super();
		addResourceLinkerItem("rubyscript", "&Ruby Script", new RubyScriptLink() );
		addResourceLinkerItem("css", "&Style Sheet", new CSSLink() );
		
		pref.addPropertyChangeListener(prefListener);
	}
	
	public void contributeToToolBar(IToolBarManager mgr) {
		super.contributeToToolBar(mgr);
		/*
		Action tableAct = new Action("Table", WebpubUIPlugin.getImageDescriptor("clcl16/table.gif")){
			public void run(){
				
			}
		};
		mgr.add(tableAct);
		*/
	}
	
	void addResourceLinkerItem( String id, String name, IRelativeResourceLinkChooser chooser){
		linkFactories.add(new Object[]{id, name, chooser, null});
	}
	
	String[] getIdList(){
		Object[] items = linkFactories.toArray();
		String[] ids = new String[items.length];
		for (int i = 0; i < items.length; i++) {
			ids[i] = (String)((Object[])items[i])[0];
		}
		return ids;
	}
	
	Object[] findItem(String id){
		Object[] items = linkFactories.toArray();
		for (int i = 0; i <items.length; i++) {
			Object[] item = (Object[])items[i];
			if( item[0].equals(id) ){
				return item;
			}
		}
		return null;
	}
	
	String getItemName(String id){
		return (String)findItem(id)[1];
	}
	
	IAction getOpenLinkAction(String id){
		Object[] item = findItem(id);
		IAction act = (IAction)item[3];
		if( act == null){
			final String name = (String)findItem(id)[1];
			final IRelativeResourceLinkChooser chooser = (IRelativeResourceLinkChooser)item[2];
			act = new Action(name){
				public void run(){
					if( activeEditor != null){
						try {
							IDE.openEditor(getPage(), chooser.chooseLink(activeEditor), true);
						} catch (CoreException e) {
							WebpubUIPlugin.handleException(e);
						}
					}
				}
			};
			item[3] = act;
		}
		
		return act;
	}

	public void contributeToMenu(IMenuManager menu) {
		super.contributeToMenu(menu);
		
		// addition link menu to navigate menu
		IMenuManager naviMenuMgr = menu.findMenuUsingPath(IWorkbenchActionConstants.M_NAVIGATE);
		
		if( naviMenuMgr != null){
			linkMenu = new MenuManager("&Relational File", M_ID_RELLINK);
			naviMenuMgr.appendToGroup(IWorkbenchActionConstants.OPEN_EXT, linkMenu);
			String[] ids = getIdList();
			for (int i = 0; i < ids.length; i++) {
				String id = ids[i];
				linkMenu.add(getOpenLinkAction(id));
			}
		}
		
		// define word wrap option in editor menu
		IMenuManager editMenuMgr = menu.findMenuUsingPath(IWorkbenchActionConstants.M_EDIT);
		if( editMenuMgr != null){
			editMenuMgr.appendToGroup(IWorkbenchActionConstants.EDIT_END, new Separator(M_PREFERENCE) );
			editMenuMgr.appendToGroup(M_PREFERENCE, getWordWrapCheckAction() );
		}
		
		refreshActionStatus();
	}
	
	void refreshActionStatus(){
		if(wordWrapAction != null){
			wordWrapAction.setChecked( pref.getBoolean(WebpubUIPlugin.HTEDITOR_WORDWRAP) );
		}
	}
		
	IAction getWordWrapCheckAction(){
		if( wordWrapAction == null){
			wordWrapAction = new Action("&Word Wrap", IAction.AS_CHECK_BOX){
				public void run(){
					boolean wordWraped = pref.getBoolean(WebpubUIPlugin.HTEDITOR_WORDWRAP);
					pref.setValue( WebpubUIPlugin.HTEDITOR_WORDWRAP, !wordWraped);
				}
			};
		}
		return wordWrapAction;
	}
	
	public void setActiveEditor(IEditorPart part) {
		super.setActiveEditor(part);
		if(part == activeEditor){
			return;
		}
		if(part instanceof ITextEditor){
			activeEditor = (ITextEditor)part;
			Object[] items = linkFactories.toArray();
			for (int i = 0; i < items.length; i++) {
				Object[] item = (Object[])items[i];
				
				String id = (String)item[0];
				IAction act = getOpenLinkAction(id);
				
				String  name = (String)item[1];
				IRelativeResourceLinkChooser chooser = 
					(IRelativeResourceLinkChooser)item[2];
			
				try{
					IFile f = chooser.chooseLink(activeEditor);
					boolean openTargetExist = f != null;
					if( openTargetExist){
						act.setText(name + " (" + f.getName() + ")");
					}else{
						act.setText(name);
					}
					act.setEnabled(openTargetExist);
					
				}catch(CoreException e){
					WebpubUIPlugin.handleException(e);
				}
			}
		}else{
			activeEditor = null;
			linkMenu.setVisible(false);
		}
		linkMenu.updateAll(true);
	}

	public void dispose() {
		pref.removePropertyChangeListener(prefListener);
		super.dispose();
	}

}
