/*
 * $Id: HTOutlinePropertySource.java,v 1.3 2004/06/07 06:46:17 hn Exp $
 * Copyright Narushima Hironori. All rights reserved.
 */
package com.narucy.webpub.ui.editors.html;

import org.eclipse.ui.views.properties.*;

import com.narucy.webpub.core.template.*;

class HTOutlinePropertySource implements IPropertySource {

	final static Integer
		NAME = new Integer(0),
		LINE_NUMBER = new Integer(1);

	public Object getEditableValue() {
		return this;
	}

	Template template;

	public void setTemplate(Template tmpl) {
		template = tmpl;
	}
	
	public IPropertyDescriptor[] getPropertyDescriptors() {
		return new IPropertyDescriptor[]{
			new PropertyDescriptor(NAME, "Name"),
			new PropertyDescriptor(LINE_NUMBER, "Line Number")
		};
	}
	
	public Object getPropertyValue(Object id) {
		if(id.equals(NAME)){
			return template.getName();
		}
		if(id.equals(LINE_NUMBER)){
			Integer lineNum = (Integer)template.getProperty(TemplateParser.PROP_OFFSET_LINE);
			return lineNum != null ? lineNum.toString() : "";
		}
		return null;
	}
	
	public boolean isPropertySet(Object id) {
		return getPropertyValue(id) != null;
	}

	public void resetPropertyValue(Object id) {
	}

	public void setPropertyValue(Object id, Object val) {
	}

}