/*
 * $Id: RubyScriptLink.java,v 1.5 2004/06/07 06:46:18 hn Exp $
 * Copyright Narushima Hironori. All rights reserved.
 */
package com.narucy.webpub.ui.editors.html;

import java.io.IOException;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.*;
import org.eclipse.ui.*;
import org.eclipse.ui.texteditor.ITextEditor;

import com.narucy.webpub.core.WebProject;
import com.narucy.webpub.core.publish.*;
import com.narucy.webpub.ui.WebpubUIPlugin;

class RubyScriptLink implements IRelativeResourceLinkChooser {

	public IFile chooseLink(final ITextEditor editor) throws CoreException {
		IEditorInput input = editor.getEditorInput();
		try{
			if(input instanceof IFileEditorInput){
				IFile htFile = ((IFileEditorInput)input).getFile();
				if(htFile != null){
					WebProject webProject = (WebProject)htFile.getProject().getNature(WebProject.ID_NATURE);
					if(webProject != null){
						PublishDescription publishDesc = webProject.getPublishDescriptionFactory().create(htFile);
						if( publishDesc != null){
							String scriptPath = publishDesc.getArgument("script");
							if( scriptPath != null){
								return webProject.getFolder(WebProject.SCRIPTS_FOLDER).getFile(new Path(scriptPath));
							}
						}
					}
				}
			}
		} catch(IOException e){
			WebpubUIPlugin.handleException(e);
		} catch (IllegalConfigurationException e) {
			WebpubUIPlugin.handleException(e);
		}
		
		return null;
	}
	
}

